/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.InputFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityRecognizerDocuments
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityRecognizerDocuments> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Uri").getter(EntityRecognizerDocuments.getter(EntityRecognizerDocuments::s3Uri)).setter(EntityRecognizerDocuments.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()}).build();
    private static final SdkField<String> TEST_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TestS3Uri").getter(EntityRecognizerDocuments.getter(EntityRecognizerDocuments::testS3Uri)).setter(EntityRecognizerDocuments.setter(Builder::testS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestS3Uri").build()}).build();
    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFormat").getter(EntityRecognizerDocuments.getter(EntityRecognizerDocuments::inputFormatAsString)).setter(EntityRecognizerDocuments.setter(Builder::inputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, TEST_S3_URI_FIELD, INPUT_FORMAT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final String testS3Uri;
    private final String inputFormat;

    private EntityRecognizerDocuments(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.testS3Uri = builder.testS3Uri;
        this.inputFormat = builder.inputFormat;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final String testS3Uri() {
        return this.testS3Uri;
    }

    public final InputFormat inputFormat() {
        return InputFormat.fromValue(this.inputFormat);
    }

    public final String inputFormatAsString() {
        return this.inputFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.testS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerDocuments)) {
            return false;
        }
        EntityRecognizerDocuments other = (EntityRecognizerDocuments)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.testS3Uri(), other.testS3Uri()) && Objects.equals(this.inputFormatAsString(), other.inputFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EntityRecognizerDocuments").add("S3Uri", (Object)this.s3Uri()).add("TestS3Uri", (Object)this.testS3Uri()).add("InputFormat", (Object)this.inputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "TestS3Uri": {
                return Optional.ofNullable(clazz.cast(this.testS3Uri()));
            }
            case "InputFormat": {
                return Optional.ofNullable(clazz.cast(this.inputFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerDocuments, T> g) {
        return obj -> g.apply((EntityRecognizerDocuments)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private String testS3Uri;
        private String inputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerDocuments model) {
            this.s3Uri(model.s3Uri);
            this.testS3Uri(model.testS3Uri);
            this.inputFormat(model.inputFormat);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        @Transient
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getTestS3Uri() {
            return this.testS3Uri;
        }

        public final void setTestS3Uri(String testS3Uri) {
            this.testS3Uri = testS3Uri;
        }

        @Override
        @Transient
        public final Builder testS3Uri(String testS3Uri) {
            this.testS3Uri = testS3Uri;
            return this;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        @Transient
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public EntityRecognizerDocuments build() {
            return new EntityRecognizerDocuments(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityRecognizerDocuments> {
        public Builder s3Uri(String var1);

        public Builder testS3Uri(String var1);

        public Builder inputFormat(String var1);

        public Builder inputFormat(InputFormat var1);
    }
}

