/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyPhrasesDetectionJobFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyPhrasesDetectionJobFilter> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(KeyPhrasesDetectionJobFilter.getter(KeyPhrasesDetectionJobFilter::jobName)).setter(KeyPhrasesDetectionJobFilter.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(KeyPhrasesDetectionJobFilter.getter(KeyPhrasesDetectionJobFilter::jobStatusAsString)).setter(KeyPhrasesDetectionJobFilter.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTimeBefore").getter(KeyPhrasesDetectionJobFilter.getter(KeyPhrasesDetectionJobFilter::submitTimeBefore)).setter(KeyPhrasesDetectionJobFilter.setter(Builder::submitTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeBefore").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTimeAfter").getter(KeyPhrasesDetectionJobFilter.getter(KeyPhrasesDetectionJobFilter::submitTimeAfter)).setter(KeyPhrasesDetectionJobFilter.setter(Builder::submitTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_STATUS_FIELD, SUBMIT_TIME_BEFORE_FIELD, SUBMIT_TIME_AFTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final String jobStatus;
    private final Instant submitTimeBefore;
    private final Instant submitTimeAfter;

    private KeyPhrasesDetectionJobFilter(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.submitTimeAfter = builder.submitTimeAfter;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final Instant submitTimeBefore() {
        return this.submitTimeBefore;
    }

    public final Instant submitTimeAfter() {
        return this.submitTimeAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTimeAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPhrasesDetectionJobFilter)) {
            return false;
        }
        KeyPhrasesDetectionJobFilter other = (KeyPhrasesDetectionJobFilter)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.submitTimeBefore(), other.submitTimeBefore()) && Objects.equals(this.submitTimeAfter(), other.submitTimeAfter());
    }

    public final String toString() {
        return ToString.builder((String)"KeyPhrasesDetectionJobFilter").add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("SubmitTimeBefore", (Object)this.submitTimeBefore()).add("SubmitTimeAfter", (Object)this.submitTimeAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "SubmitTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.submitTimeBefore()));
            }
            case "SubmitTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.submitTimeAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyPhrasesDetectionJobFilter, T> g) {
        return obj -> g.apply((KeyPhrasesDetectionJobFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobStatus;
        private Instant submitTimeBefore;
        private Instant submitTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPhrasesDetectionJobFilter model) {
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.submitTimeBefore(model.submitTimeBefore);
            this.submitTimeAfter(model.submitTimeAfter);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Instant getSubmitTimeBefore() {
            return this.submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        public final Instant getSubmitTimeAfter() {
            return this.submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        public KeyPhrasesDetectionJobFilter build() {
            return new KeyPhrasesDetectionJobFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyPhrasesDetectionJobFilter> {
        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder submitTimeBefore(Instant var1);

        public Builder submitTimeAfter(Instant var1);
    }
}

