/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InputFormat {
    ONE_DOC_PER_FILE("ONE_DOC_PER_FILE"),
    ONE_DOC_PER_LINE("ONE_DOC_PER_LINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputFormat> knownValues() {
        return Stream.of(InputFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

