/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEntityRecognizerRequest extends ComprehendRequest implements
        ToCopyableBuilder<CreateEntityRecognizerRequest.Builder, CreateEntityRecognizerRequest> {
    private static final SdkField<String> RECOGNIZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecognizerName").getter(getter(CreateEntityRecognizerRequest::recognizerName))
            .setter(setter(Builder::recognizerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecognizerName").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(CreateEntityRecognizerRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEntityRecognizerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EntityRecognizerInputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<EntityRecognizerInputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(CreateEntityRecognizerRequest::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(EntityRecognizerInputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateEntityRecognizerRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CreateEntityRecognizerRequest::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeKmsKeyId").getter(getter(CreateEntityRecognizerRequest::volumeKmsKeyId))
            .setter(setter(Builder::volumeKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateEntityRecognizerRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOGNIZER_NAME_FIELD,
            DATA_ACCESS_ROLE_ARN_FIELD, TAGS_FIELD, INPUT_DATA_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, LANGUAGE_CODE_FIELD,
            VOLUME_KMS_KEY_ID_FIELD, VPC_CONFIG_FIELD));

    private final String recognizerName;

    private final String dataAccessRoleArn;

    private final List<Tag> tags;

    private final EntityRecognizerInputDataConfig inputDataConfig;

    private final String clientRequestToken;

    private final String languageCode;

    private final String volumeKmsKeyId;

    private final VpcConfig vpcConfig;

    private CreateEntityRecognizerRequest(BuilderImpl builder) {
        super(builder);
        this.recognizerName = builder.recognizerName;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.tags = builder.tags;
        this.inputDataConfig = builder.inputDataConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.languageCode = builder.languageCode;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters. Alphanumeric
     * characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the account/region.
     * </p>
     * 
     * @return The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters.
     *         Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the
     *         account/region.
     */
    public final String recognizerName() {
        return recognizerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read
     * access to your input data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon
     *         Comprehend read access to your input data.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a metadata
     * to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource
     * to indicate its use by the sales department.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a
     *         metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be
     *         added to a resource to indicate its use by the sales department.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies the format and location of the input data. The S3 bucket containing the input data must be located in
     * the same region as the entity recognizer being created.
     * </p>
     * 
     * @return Specifies the format and location of the input data. The S3 bucket containing the input data must be
     *         located in the same region as the entity recognizer being created.
     */
    public final EntityRecognizerInputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you don't set the client request token, Amazon Comprehend
     *         generates one.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish ("es"),
     * French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish
     *         ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the
     *         same language.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * <p>
     * You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish ("es"),
     * French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the same language.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish
     *         ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the
     *         same language.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * <p>
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume
     * attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the
     * following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Resource Name (ARN) of a KMS Key:
     * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the
     *         storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId
     *         can be either of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN) of a KMS Key:
     *         <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     */
    public final String volumeKmsKeyId() {
        return volumeKmsKeyId;
    }

    /**
     * <p>
     * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
     * using for your custom entity recognizer. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
     * </p>
     * 
     * @return Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you
     *         are using for your custom entity recognizer. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recognizerName());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEntityRecognizerRequest)) {
            return false;
        }
        CreateEntityRecognizerRequest other = (CreateEntityRecognizerRequest) obj;
        return Objects.equals(recognizerName(), other.recognizerName())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEntityRecognizerRequest").add("RecognizerName", recognizerName())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("Tags", hasTags() ? tags() : null)
                .add("InputDataConfig", inputDataConfig()).add("ClientRequestToken", clientRequestToken())
                .add("LanguageCode", languageCodeAsString()).add("VolumeKmsKeyId", volumeKmsKeyId())
                .add("VpcConfig", vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecognizerName":
            return Optional.ofNullable(clazz.cast(recognizerName()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "VolumeKmsKeyId":
            return Optional.ofNullable(clazz.cast(volumeKmsKeyId()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEntityRecognizerRequest, T> g) {
        return obj -> g.apply((CreateEntityRecognizerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEntityRecognizerRequest> {
        /**
         * <p>
         * The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters.
         * Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the
         * account/region.
         * </p>
         * 
         * @param recognizerName
         *        The name given to the newly created recognizer. Recognizer names can be a maximum of 256 characters.
         *        Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The name must be unique in the
         *        account/region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recognizerName(String recognizerName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend
         * read access to your input data.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon
         *        Comprehend read access to your input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a
         * metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added
         * to a resource to indicate its use by the sales department.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as
         *        a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might
         *        be added to a resource to indicate its use by the sales department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a
         * metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added
         * to a resource to indicate its use by the sales department.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as
         *        a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might
         *        be added to a resource to indicate its use by the sales department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to be associated with the entity recognizer being created. A tag is a key-value pair that adds as a
         * metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added
         * to a resource to indicate its use by the sales department.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies the format and location of the input data. The S3 bucket containing the input data must be located
         * in the same region as the entity recognizer being created.
         * </p>
         * 
         * @param inputDataConfig
         *        Specifies the format and location of the input data. The S3 bucket containing the input data must be
         *        located in the same region as the entity recognizer being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(EntityRecognizerInputDataConfig inputDataConfig);

        /**
         * <p>
         * Specifies the format and location of the input data. The S3 bucket containing the input data must be located
         * in the same region as the entity recognizer being created.
         * </p>
         * This is a convenience that creates an instance of the {@link EntityRecognizerInputDataConfig.Builder}
         * avoiding the need to create one manually via {@link EntityRecognizerInputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EntityRecognizerInputDataConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDataConfig(EntityRecognizerInputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link EntityRecognizerInputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(EntityRecognizerInputDataConfig)
         */
        default Builder inputDataConfig(Consumer<EntityRecognizerInputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(EntityRecognizerInputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * A unique identifier for the request. If you don't set the client request token, Amazon Comprehend generates
         * one.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique identifier for the request. If you don't set the client request token, Amazon Comprehend
         *        generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish
         * ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the same
         * language.
         * </p>
         * 
         * @param languageCode
         *        You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish
         *        ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in
         *        the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * <p>
         * You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish
         * ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in the same
         * language.
         * </p>
         * 
         * @param languageCode
         *        You can specify any of the following languages supported by Amazon Comprehend: English ("en"), Spanish
         *        ("es"), French ("fr"), Italian ("it"), German ("de"), or Portuguese ("pt"). All documents must be in
         *        the same language.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * <p>
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage
         * volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either
         * of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN) of a KMS Key:
         * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeKmsKeyId
         *        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the
         *        storage volume attached to the ML compute instance(s) that process the analysis job. The
         *        VolumeKmsKeyId can be either of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN) of a KMS Key:
         *        <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeKmsKeyId(String volumeKmsKeyId);

        /**
         * <p>
         * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
         * using for your custom entity recognizer. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * </p>
         * 
         * @param vpcConfig
         *        Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources
         *        you are using for your custom entity recognizer. For more information, see <a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are
         * using for your custom entity recognizer. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ComprehendRequest.BuilderImpl implements Builder {
        private String recognizerName;

        private String dataAccessRoleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private EntityRecognizerInputDataConfig inputDataConfig;

        private String clientRequestToken;

        private String languageCode;

        private String volumeKmsKeyId;

        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEntityRecognizerRequest model) {
            super(model);
            recognizerName(model.recognizerName);
            dataAccessRoleArn(model.dataAccessRoleArn);
            tags(model.tags);
            inputDataConfig(model.inputDataConfig);
            clientRequestToken(model.clientRequestToken);
            languageCode(model.languageCode);
            volumeKmsKeyId(model.volumeKmsKeyId);
            vpcConfig(model.vpcConfig);
        }

        public final String getRecognizerName() {
            return recognizerName;
        }

        @Override
        public final Builder recognizerName(String recognizerName) {
            this.recognizerName = recognizerName;
            return this;
        }

        public final void setRecognizerName(String recognizerName) {
            this.recognizerName = recognizerName;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final EntityRecognizerInputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(EntityRecognizerInputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(EntityRecognizerInputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getVolumeKmsKeyId() {
            return volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEntityRecognizerRequest build() {
            return new CreateEntityRecognizerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
