/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentLabel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentLabel> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DocumentLabel.getter(DocumentLabel::name)).setter(DocumentLabel.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Float> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Score").getter(DocumentLabel.getter(DocumentLabel::score)).setter(DocumentLabel.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCORE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Float score;

    private DocumentLabel(BuilderImpl builder) {
        this.name = builder.name;
        this.score = builder.score;
    }

    public String name() {
        return this.name;
    }

    public Float score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentLabel)) {
            return false;
        }
        DocumentLabel other = (DocumentLabel)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.score(), other.score());
    }

    public String toString() {
        return ToString.builder((String)"DocumentLabel").add("Name", (Object)this.name()).add("Score", (Object)this.score()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentLabel, T> g) {
        return obj -> g.apply((DocumentLabel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Float score;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentLabel model) {
            this.name(model.name);
            this.score(model.score);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public DocumentLabel build() {
            return new DocumentLabel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentLabel> {
        public Builder name(String var1);

        public Builder score(Float var1);
    }
}

