/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.Entity;
import software.amazon.awssdk.services.comprehend.model.ListOfEntitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDetectEntitiesItemResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchDetectEntitiesItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BatchDetectEntitiesItemResult.getter(BatchDetectEntitiesItemResult::index)).setter(BatchDetectEntitiesItemResult.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDetectEntitiesItemResult.getter(BatchDetectEntitiesItemResult::entities)).setter(BatchDetectEntitiesItemResult.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, ENTITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final List<Entity> entities;

    private BatchDetectEntitiesItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.entities = builder.entities;
    }

    public Integer index() {
        return this.index;
    }

    public boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public List<Entity> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.entities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectEntitiesItemResult)) {
            return false;
        }
        BatchDetectEntitiesItemResult other = (BatchDetectEntitiesItemResult)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.entities(), other.entities());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectEntitiesItemResult").add("Index", (Object)this.index()).add("Entities", this.entities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "Entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectEntitiesItemResult, T> g) {
        return obj -> g.apply((BatchDetectEntitiesItemResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectEntitiesItemResult model) {
            this.index(model.index);
            this.entities(model.entities);
        }

        public final Integer getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final Collection<Entity.Builder> getEntities() {
            return this.entities != null ? (Collection)this.entities.stream().map(Entity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = ListOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Entity)((Entity.Builder)Entity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = ListOfEntitiesCopier.copyFromBuilder(entities);
        }

        public BatchDetectEntitiesItemResult build() {
            return new BatchDetectEntitiesItemResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchDetectEntitiesItemResult> {
        public Builder index(Integer var1);

        public Builder entities(Collection<Entity> var1);

        public Builder entities(Entity ... var1);

        public Builder entities(Consumer<Entity.Builder> ... var1);
    }
}

