/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ListOfPiiEntityTypesCopier;
import software.amazon.awssdk.services.comprehend.model.PiiEntitiesDetectionMaskMode;
import software.amazon.awssdk.services.comprehend.model.PiiEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedactionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedactionConfig> {
    private static final SdkField<List<String>> PII_ENTITY_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RedactionConfig.getter(RedactionConfig::piiEntityTypesAsStrings)).setter(RedactionConfig.setter(Builder::piiEntityTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PiiEntityTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MASK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RedactionConfig.getter(RedactionConfig::maskModeAsString)).setter(RedactionConfig.setter(Builder::maskMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaskMode").build()}).build();
    private static final SdkField<String> MASK_CHARACTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RedactionConfig.getter(RedactionConfig::maskCharacter)).setter(RedactionConfig.setter(Builder::maskCharacter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaskCharacter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITY_TYPES_FIELD, MASK_MODE_FIELD, MASK_CHARACTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> piiEntityTypes;
    private final String maskMode;
    private final String maskCharacter;

    private RedactionConfig(BuilderImpl builder) {
        this.piiEntityTypes = builder.piiEntityTypes;
        this.maskMode = builder.maskMode;
        this.maskCharacter = builder.maskCharacter;
    }

    public List<PiiEntityType> piiEntityTypes() {
        return ListOfPiiEntityTypesCopier.copyStringToEnum(this.piiEntityTypes);
    }

    public boolean hasPiiEntityTypes() {
        return this.piiEntityTypes != null && !(this.piiEntityTypes instanceof SdkAutoConstructList);
    }

    public List<String> piiEntityTypesAsStrings() {
        return this.piiEntityTypes;
    }

    public PiiEntitiesDetectionMaskMode maskMode() {
        return PiiEntitiesDetectionMaskMode.fromValue(this.maskMode);
    }

    public String maskModeAsString() {
        return this.maskMode;
    }

    public String maskCharacter() {
        return this.maskCharacter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.piiEntityTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.maskModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maskCharacter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactionConfig)) {
            return false;
        }
        RedactionConfig other = (RedactionConfig)obj;
        return Objects.equals(this.piiEntityTypesAsStrings(), other.piiEntityTypesAsStrings()) && Objects.equals(this.maskModeAsString(), other.maskModeAsString()) && Objects.equals(this.maskCharacter(), other.maskCharacter());
    }

    public String toString() {
        return ToString.builder((String)"RedactionConfig").add("PiiEntityTypes", this.piiEntityTypesAsStrings()).add("MaskMode", (Object)this.maskModeAsString()).add("MaskCharacter", (Object)this.maskCharacter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PiiEntityTypes": {
                return Optional.ofNullable(clazz.cast(this.piiEntityTypesAsStrings()));
            }
            case "MaskMode": {
                return Optional.ofNullable(clazz.cast(this.maskModeAsString()));
            }
            case "MaskCharacter": {
                return Optional.ofNullable(clazz.cast(this.maskCharacter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedactionConfig, T> g) {
        return obj -> g.apply((RedactionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> piiEntityTypes = DefaultSdkAutoConstructList.getInstance();
        private String maskMode;
        private String maskCharacter;

        private BuilderImpl() {
        }

        private BuilderImpl(RedactionConfig model) {
            this.piiEntityTypesWithStrings(model.piiEntityTypes);
            this.maskMode(model.maskMode);
            this.maskCharacter(model.maskCharacter);
        }

        public final Collection<String> getPiiEntityTypes() {
            return this.piiEntityTypes;
        }

        @Override
        public final Builder piiEntityTypesWithStrings(Collection<String> piiEntityTypes) {
            this.piiEntityTypes = ListOfPiiEntityTypesCopier.copy(piiEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntityTypesWithStrings(String ... piiEntityTypes) {
            this.piiEntityTypesWithStrings(Arrays.asList(piiEntityTypes));
            return this;
        }

        @Override
        public final Builder piiEntityTypes(Collection<PiiEntityType> piiEntityTypes) {
            this.piiEntityTypes = ListOfPiiEntityTypesCopier.copyEnumToString(piiEntityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntityTypes(PiiEntityType ... piiEntityTypes) {
            this.piiEntityTypes(Arrays.asList(piiEntityTypes));
            return this;
        }

        public final void setPiiEntityTypes(Collection<String> piiEntityTypes) {
            this.piiEntityTypes = ListOfPiiEntityTypesCopier.copy(piiEntityTypes);
        }

        public final String getMaskMode() {
            return this.maskMode;
        }

        @Override
        public final Builder maskMode(String maskMode) {
            this.maskMode = maskMode;
            return this;
        }

        @Override
        public final Builder maskMode(PiiEntitiesDetectionMaskMode maskMode) {
            this.maskMode(maskMode == null ? null : maskMode.toString());
            return this;
        }

        public final void setMaskMode(String maskMode) {
            this.maskMode = maskMode;
        }

        public final String getMaskCharacter() {
            return this.maskCharacter;
        }

        @Override
        public final Builder maskCharacter(String maskCharacter) {
            this.maskCharacter = maskCharacter;
            return this;
        }

        public final void setMaskCharacter(String maskCharacter) {
            this.maskCharacter = maskCharacter;
        }

        public RedactionConfig build() {
            return new RedactionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedactionConfig> {
        public Builder piiEntityTypesWithStrings(Collection<String> var1);

        public Builder piiEntityTypesWithStrings(String ... var1);

        public Builder piiEntityTypes(Collection<PiiEntityType> var1);

        public Builder piiEntityTypes(PiiEntityType ... var1);

        public Builder maskMode(String var1);

        public Builder maskMode(PiiEntitiesDetectionMaskMode var1);

        public Builder maskCharacter(String var1);
    }
}

