/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEndpointsResponse extends ComprehendResponse implements
        ToCopyableBuilder<ListEndpointsResponse.Builder, ListEndpointsResponse> {
    private static final SdkField<List<EndpointProperties>> ENDPOINT_PROPERTIES_LIST_FIELD = SdkField
            .<List<EndpointProperties>> builder(MarshallingType.LIST)
            .getter(getter(ListEndpointsResponse::endpointPropertiesList))
            .setter(setter(Builder::endpointPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointPropertiesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEndpointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENDPOINT_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<EndpointProperties> endpointPropertiesList;

    private final String nextToken;

    private ListEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpointPropertiesList = builder.endpointPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EndpointPropertiesList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEndpointPropertiesList() {
        return endpointPropertiesList != null && !(endpointPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Displays a list of endpoint properties being retrieved by the service in response to the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpointPropertiesList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Displays a list of endpoint properties being retrieved by the service in response to the request.
     */
    public List<EndpointProperties> endpointPropertiesList() {
        return endpointPropertiesList;
    }

    /**
     * <p>
     * Identifies the next page of results to return.
     * </p>
     * 
     * @return Identifies the next page of results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointPropertiesList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsResponse)) {
            return false;
        }
        ListEndpointsResponse other = (ListEndpointsResponse) obj;
        return Objects.equals(endpointPropertiesList(), other.endpointPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEndpointsResponse").add("EndpointPropertiesList", endpointPropertiesList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointPropertiesList":
            return Optional.ofNullable(clazz.cast(endpointPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointsResponse, T> g) {
        return obj -> g.apply((ListEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEndpointsResponse> {
        /**
         * <p>
         * Displays a list of endpoint properties being retrieved by the service in response to the request.
         * </p>
         * 
         * @param endpointPropertiesList
         *        Displays a list of endpoint properties being retrieved by the service in response to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPropertiesList(Collection<EndpointProperties> endpointPropertiesList);

        /**
         * <p>
         * Displays a list of endpoint properties being retrieved by the service in response to the request.
         * </p>
         * 
         * @param endpointPropertiesList
         *        Displays a list of endpoint properties being retrieved by the service in response to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointPropertiesList(EndpointProperties... endpointPropertiesList);

        /**
         * <p>
         * Displays a list of endpoint properties being retrieved by the service in response to the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndpointProperties>.Builder} avoiding the
         * need to create one manually via {@link List<EndpointProperties>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointProperties>.Builder#build()} is called immediately
         * and its result is passed to {@link #endpointPropertiesList(List<EndpointProperties>)}.
         * 
         * @param endpointPropertiesList
         *        a consumer that will call methods on {@link List<EndpointProperties>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointPropertiesList(List<EndpointProperties>)
         */
        Builder endpointPropertiesList(Consumer<EndpointProperties.Builder>... endpointPropertiesList);

        /**
         * <p>
         * Identifies the next page of results to return.
         * </p>
         * 
         * @param nextToken
         *        Identifies the next page of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<EndpointProperties> endpointPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsResponse model) {
            super(model);
            endpointPropertiesList(model.endpointPropertiesList);
            nextToken(model.nextToken);
        }

        public final Collection<EndpointProperties.Builder> getEndpointPropertiesList() {
            return endpointPropertiesList != null ? endpointPropertiesList.stream().map(EndpointProperties::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpointPropertiesList(Collection<EndpointProperties> endpointPropertiesList) {
            this.endpointPropertiesList = EndpointPropertiesListCopier.copy(endpointPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointPropertiesList(EndpointProperties... endpointPropertiesList) {
            endpointPropertiesList(Arrays.asList(endpointPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointPropertiesList(Consumer<EndpointProperties.Builder>... endpointPropertiesList) {
            endpointPropertiesList(Stream.of(endpointPropertiesList)
                    .map(c -> EndpointProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointPropertiesList(Collection<EndpointProperties.BuilderImpl> endpointPropertiesList) {
            this.endpointPropertiesList = EndpointPropertiesListCopier.copyFromBuilder(endpointPropertiesList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointsResponse build() {
            return new ListEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
