/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectKeyPhrasesResponse extends ComprehendResponse implements
        ToCopyableBuilder<DetectKeyPhrasesResponse.Builder, DetectKeyPhrasesResponse> {
    private static final SdkField<List<KeyPhrase>> KEY_PHRASES_FIELD = SdkField
            .<List<KeyPhrase>> builder(MarshallingType.LIST)
            .getter(getter(DetectKeyPhrasesResponse::keyPhrases))
            .setter(setter(Builder::keyPhrases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPhrases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyPhrase> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyPhrase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PHRASES_FIELD));

    private final List<KeyPhrase> keyPhrases;

    private DetectKeyPhrasesResponse(BuilderImpl builder) {
        super(builder);
        this.keyPhrases = builder.keyPhrases;
    }

    /**
     * Returns true if the KeyPhrases property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyPhrases() {
        return keyPhrases != null && !(keyPhrases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase, the
     * response provides the text of the key phrase, where the key phrase begins and ends, and the level of confidence
     * that Amazon Comprehend has in the accuracy of the detection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyPhrases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase, the
     *         response provides the text of the key phrase, where the key phrase begins and ends, and the level of
     *         confidence that Amazon Comprehend has in the accuracy of the detection.
     */
    public List<KeyPhrase> keyPhrases() {
        return keyPhrases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyPhrases());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectKeyPhrasesResponse)) {
            return false;
        }
        DetectKeyPhrasesResponse other = (DetectKeyPhrasesResponse) obj;
        return Objects.equals(keyPhrases(), other.keyPhrases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectKeyPhrasesResponse").add("KeyPhrases", keyPhrases()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyPhrases":
            return Optional.ofNullable(clazz.cast(keyPhrases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectKeyPhrasesResponse, T> g) {
        return obj -> g.apply((DetectKeyPhrasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectKeyPhrasesResponse> {
        /**
         * <p>
         * A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase, the
         * response provides the text of the key phrase, where the key phrase begins and ends, and the level of
         * confidence that Amazon Comprehend has in the accuracy of the detection.
         * </p>
         * 
         * @param keyPhrases
         *        A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase,
         *        the response provides the text of the key phrase, where the key phrase begins and ends, and the level
         *        of confidence that Amazon Comprehend has in the accuracy of the detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrases(Collection<KeyPhrase> keyPhrases);

        /**
         * <p>
         * A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase, the
         * response provides the text of the key phrase, where the key phrase begins and ends, and the level of
         * confidence that Amazon Comprehend has in the accuracy of the detection.
         * </p>
         * 
         * @param keyPhrases
         *        A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase,
         *        the response provides the text of the key phrase, where the key phrase begins and ends, and the level
         *        of confidence that Amazon Comprehend has in the accuracy of the detection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrases(KeyPhrase... keyPhrases);

        /**
         * <p>
         * A collection of key phrases that Amazon Comprehend identified in the input text. For each key phrase, the
         * response provides the text of the key phrase, where the key phrase begins and ends, and the level of
         * confidence that Amazon Comprehend has in the accuracy of the detection.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeyPhrase>.Builder} avoiding the need to
         * create one manually via {@link List<KeyPhrase>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyPhrase>.Builder#build()} is called immediately and its
         * result is passed to {@link #keyPhrases(List<KeyPhrase>)}.
         * 
         * @param keyPhrases
         *        a consumer that will call methods on {@link List<KeyPhrase>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPhrases(List<KeyPhrase>)
         */
        Builder keyPhrases(Consumer<KeyPhrase.Builder>... keyPhrases);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<KeyPhrase> keyPhrases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectKeyPhrasesResponse model) {
            super(model);
            keyPhrases(model.keyPhrases);
        }

        public final Collection<KeyPhrase.Builder> getKeyPhrases() {
            return keyPhrases != null ? keyPhrases.stream().map(KeyPhrase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPhrases(Collection<KeyPhrase> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copy(keyPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(KeyPhrase... keyPhrases) {
            keyPhrases(Arrays.asList(keyPhrases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(Consumer<KeyPhrase.Builder>... keyPhrases) {
            keyPhrases(Stream.of(keyPhrases).map(c -> KeyPhrase.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPhrases(Collection<KeyPhrase.BuilderImpl> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copyFromBuilder(keyPhrases);
        }

        @Override
        public DetectKeyPhrasesResponse build() {
            return new DetectKeyPhrasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
