/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTopicsDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeTopicsDetectionJobResponse.Builder, DescribeTopicsDetectionJobResponse> {
    private static final SdkField<TopicsDetectionJobProperties> TOPICS_DETECTION_JOB_PROPERTIES_FIELD = SdkField
            .<TopicsDetectionJobProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeTopicsDetectionJobResponse::topicsDetectionJobProperties))
            .setter(setter(Builder::topicsDetectionJobProperties))
            .constructor(TopicsDetectionJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicsDetectionJobProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TOPICS_DETECTION_JOB_PROPERTIES_FIELD));

    private final TopicsDetectionJobProperties topicsDetectionJobProperties;

    private DescribeTopicsDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.topicsDetectionJobProperties = builder.topicsDetectionJobProperties;
    }

    /**
     * <p>
     * The list of properties for the requested job.
     * </p>
     * 
     * @return The list of properties for the requested job.
     */
    public TopicsDetectionJobProperties topicsDetectionJobProperties() {
        return topicsDetectionJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(topicsDetectionJobProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTopicsDetectionJobResponse)) {
            return false;
        }
        DescribeTopicsDetectionJobResponse other = (DescribeTopicsDetectionJobResponse) obj;
        return Objects.equals(topicsDetectionJobProperties(), other.topicsDetectionJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTopicsDetectionJobResponse")
                .add("TopicsDetectionJobProperties", topicsDetectionJobProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicsDetectionJobProperties":
            return Optional.ofNullable(clazz.cast(topicsDetectionJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTopicsDetectionJobResponse, T> g) {
        return obj -> g.apply((DescribeTopicsDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTopicsDetectionJobResponse> {
        /**
         * <p>
         * The list of properties for the requested job.
         * </p>
         * 
         * @param topicsDetectionJobProperties
         *        The list of properties for the requested job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicsDetectionJobProperties(TopicsDetectionJobProperties topicsDetectionJobProperties);

        /**
         * <p>
         * The list of properties for the requested job.
         * </p>
         * This is a convenience that creates an instance of the {@link TopicsDetectionJobProperties.Builder} avoiding
         * the need to create one manually via {@link TopicsDetectionJobProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link TopicsDetectionJobProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #topicsDetectionJobProperties(TopicsDetectionJobProperties)}.
         * 
         * @param topicsDetectionJobProperties
         *        a consumer that will call methods on {@link TopicsDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicsDetectionJobProperties(TopicsDetectionJobProperties)
         */
        default Builder topicsDetectionJobProperties(Consumer<TopicsDetectionJobProperties.Builder> topicsDetectionJobProperties) {
            return topicsDetectionJobProperties(TopicsDetectionJobProperties.builder()
                    .applyMutation(topicsDetectionJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private TopicsDetectionJobProperties topicsDetectionJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTopicsDetectionJobResponse model) {
            super(model);
            topicsDetectionJobProperties(model.topicsDetectionJobProperties);
        }

        public final TopicsDetectionJobProperties.Builder getTopicsDetectionJobProperties() {
            return topicsDetectionJobProperties != null ? topicsDetectionJobProperties.toBuilder() : null;
        }

        @Override
        public final Builder topicsDetectionJobProperties(TopicsDetectionJobProperties topicsDetectionJobProperties) {
            this.topicsDetectionJobProperties = topicsDetectionJobProperties;
            return this;
        }

        public final void setTopicsDetectionJobProperties(TopicsDetectionJobProperties.BuilderImpl topicsDetectionJobProperties) {
            this.topicsDetectionJobProperties = topicsDetectionJobProperties != null ? topicsDetectionJobProperties.build()
                    : null;
        }

        @Override
        public DescribeTopicsDetectionJobResponse build() {
            return new DescribeTopicsDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
