/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of calling the operation. The operation returns one object for each document that is successfully
 * processed by the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectKeyPhrasesItemResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDetectKeyPhrasesItemResult.Builder, BatchDetectKeyPhrasesItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(BatchDetectKeyPhrasesItemResult::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<List<KeyPhrase>> KEY_PHRASES_FIELD = SdkField
            .<List<KeyPhrase>> builder(MarshallingType.LIST)
            .getter(getter(BatchDetectKeyPhrasesItemResult::keyPhrases))
            .setter(setter(Builder::keyPhrases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPhrases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeyPhrase> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeyPhrase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INDEX_FIELD, KEY_PHRASES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer index;

    private final List<KeyPhrase> keyPhrases;

    private BatchDetectKeyPhrasesItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.keyPhrases = builder.keyPhrases;
    }

    /**
     * <p>
     * The zero-based index of the document in the input list.
     * </p>
     * 
     * @return The zero-based index of the document in the input list.
     */
    public Integer index() {
        return index;
    }

    /**
     * Returns true if the KeyPhrases property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasKeyPhrases() {
        return keyPhrases != null && !(keyPhrases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeyPhrases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
     */
    public List<KeyPhrase> keyPhrases() {
        return keyPhrases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(keyPhrases());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectKeyPhrasesItemResult)) {
            return false;
        }
        BatchDetectKeyPhrasesItemResult other = (BatchDetectKeyPhrasesItemResult) obj;
        return Objects.equals(index(), other.index()) && Objects.equals(keyPhrases(), other.keyPhrases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDetectKeyPhrasesItemResult").add("Index", index()).add("KeyPhrases", keyPhrases()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "KeyPhrases":
            return Optional.ofNullable(clazz.cast(keyPhrases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectKeyPhrasesItemResult, T> g) {
        return obj -> g.apply((BatchDetectKeyPhrasesItemResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDetectKeyPhrasesItemResult> {
        /**
         * <p>
         * The zero-based index of the document in the input list.
         * </p>
         * 
         * @param index
         *        The zero-based index of the document in the input list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * <p>
         * One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * </p>
         * 
         * @param keyPhrases
         *        One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrases(Collection<KeyPhrase> keyPhrases);

        /**
         * <p>
         * One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * </p>
         * 
         * @param keyPhrases
         *        One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPhrases(KeyPhrase... keyPhrases);

        /**
         * <p>
         * One or more <a>KeyPhrase</a> objects, one for each key phrase detected in the document.
         * </p>
         * This is a convenience that creates an instance of the {@link List<KeyPhrase>.Builder} avoiding the need to
         * create one manually via {@link List<KeyPhrase>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<KeyPhrase>.Builder#build()} is called immediately and its
         * result is passed to {@link #keyPhrases(List<KeyPhrase>)}.
         * 
         * @param keyPhrases
         *        a consumer that will call methods on {@link List<KeyPhrase>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPhrases(List<KeyPhrase>)
         */
        Builder keyPhrases(Consumer<KeyPhrase.Builder>... keyPhrases);
    }

    static final class BuilderImpl implements Builder {
        private Integer index;

        private List<KeyPhrase> keyPhrases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectKeyPhrasesItemResult model) {
            index(model.index);
            keyPhrases(model.keyPhrases);
        }

        public final Integer getIndex() {
            return index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final Collection<KeyPhrase.Builder> getKeyPhrases() {
            return keyPhrases != null ? keyPhrases.stream().map(KeyPhrase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPhrases(Collection<KeyPhrase> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copy(keyPhrases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(KeyPhrase... keyPhrases) {
            keyPhrases(Arrays.asList(keyPhrases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPhrases(Consumer<KeyPhrase.Builder>... keyPhrases) {
            keyPhrases(Stream.of(keyPhrases).map(c -> KeyPhrase.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPhrases(Collection<KeyPhrase.BuilderImpl> keyPhrases) {
            this.keyPhrases = ListOfKeyPhrasesCopier.copyFromBuilder(keyPhrases);
        }

        @Override
        public BatchDetectKeyPhrasesItemResult build() {
            return new BatchDetectKeyPhrasesItemResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
