/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectSyntaxResponse extends ComprehendResponse implements
        ToCopyableBuilder<DetectSyntaxResponse.Builder, DetectSyntaxResponse> {
    private static final SdkField<List<SyntaxToken>> SYNTAX_TOKENS_FIELD = SdkField
            .<List<SyntaxToken>> builder(MarshallingType.LIST)
            .getter(getter(DetectSyntaxResponse::syntaxTokens))
            .setter(setter(Builder::syntaxTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyntaxTokens").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SyntaxToken> builder(MarshallingType.SDK_POJO)
                                            .constructor(SyntaxToken::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNTAX_TOKENS_FIELD));

    private final List<SyntaxToken> syntaxTokens;

    private DetectSyntaxResponse(BuilderImpl builder) {
        super(builder);
        this.syntaxTokens = builder.syntaxTokens;
    }

    /**
     * Returns true if the SyntaxTokens property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSyntaxTokens() {
        return syntaxTokens != null && !(syntaxTokens instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of syntax tokens describing the text. For each token, the response provides the text, the token
     * type, where the text begins and ends, and the level of confidence that Amazon Comprehend has that the token is
     * correct. For a list of token types, see <a>how-syntax</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSyntaxTokens()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection of syntax tokens describing the text. For each token, the response provides the text, the
     *         token type, where the text begins and ends, and the level of confidence that Amazon Comprehend has that
     *         the token is correct. For a list of token types, see <a>how-syntax</a>.
     */
    public List<SyntaxToken> syntaxTokens() {
        return syntaxTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(syntaxTokens());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectSyntaxResponse)) {
            return false;
        }
        DetectSyntaxResponse other = (DetectSyntaxResponse) obj;
        return Objects.equals(syntaxTokens(), other.syntaxTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DetectSyntaxResponse").add("SyntaxTokens", syntaxTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyntaxTokens":
            return Optional.ofNullable(clazz.cast(syntaxTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectSyntaxResponse, T> g) {
        return obj -> g.apply((DetectSyntaxResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, DetectSyntaxResponse> {
        /**
         * <p>
         * A collection of syntax tokens describing the text. For each token, the response provides the text, the token
         * type, where the text begins and ends, and the level of confidence that Amazon Comprehend has that the token
         * is correct. For a list of token types, see <a>how-syntax</a>.
         * </p>
         * 
         * @param syntaxTokens
         *        A collection of syntax tokens describing the text. For each token, the response provides the text, the
         *        token type, where the text begins and ends, and the level of confidence that Amazon Comprehend has
         *        that the token is correct. For a list of token types, see <a>how-syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syntaxTokens(Collection<SyntaxToken> syntaxTokens);

        /**
         * <p>
         * A collection of syntax tokens describing the text. For each token, the response provides the text, the token
         * type, where the text begins and ends, and the level of confidence that Amazon Comprehend has that the token
         * is correct. For a list of token types, see <a>how-syntax</a>.
         * </p>
         * 
         * @param syntaxTokens
         *        A collection of syntax tokens describing the text. For each token, the response provides the text, the
         *        token type, where the text begins and ends, and the level of confidence that Amazon Comprehend has
         *        that the token is correct. For a list of token types, see <a>how-syntax</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syntaxTokens(SyntaxToken... syntaxTokens);

        /**
         * <p>
         * A collection of syntax tokens describing the text. For each token, the response provides the text, the token
         * type, where the text begins and ends, and the level of confidence that Amazon Comprehend has that the token
         * is correct. For a list of token types, see <a>how-syntax</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SyntaxToken>.Builder} avoiding the need to
         * create one manually via {@link List<SyntaxToken>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SyntaxToken>.Builder#build()} is called immediately and its
         * result is passed to {@link #syntaxTokens(List<SyntaxToken>)}.
         * 
         * @param syntaxTokens
         *        a consumer that will call methods on {@link List<SyntaxToken>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syntaxTokens(List<SyntaxToken>)
         */
        Builder syntaxTokens(Consumer<SyntaxToken.Builder>... syntaxTokens);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private List<SyntaxToken> syntaxTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectSyntaxResponse model) {
            super(model);
            syntaxTokens(model.syntaxTokens);
        }

        public final Collection<SyntaxToken.Builder> getSyntaxTokens() {
            return syntaxTokens != null ? syntaxTokens.stream().map(SyntaxToken::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder syntaxTokens(Collection<SyntaxToken> syntaxTokens) {
            this.syntaxTokens = ListOfSyntaxTokensCopier.copy(syntaxTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syntaxTokens(SyntaxToken... syntaxTokens) {
            syntaxTokens(Arrays.asList(syntaxTokens));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syntaxTokens(Consumer<SyntaxToken.Builder>... syntaxTokens) {
            syntaxTokens(Stream.of(syntaxTokens).map(c -> SyntaxToken.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSyntaxTokens(Collection<SyntaxToken.BuilderImpl> syntaxTokens) {
            this.syntaxTokens = ListOfSyntaxTokensCopier.copyFromBuilder(syntaxTokens);
        }

        @Override
        public DetectSyntaxResponse build() {
            return new DetectSyntaxResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
