/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSentimentDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeSentimentDetectionJobResponse.Builder, DescribeSentimentDetectionJobResponse> {
    private static final SdkField<SentimentDetectionJobProperties> SENTIMENT_DETECTION_JOB_PROPERTIES_FIELD = SdkField
            .<SentimentDetectionJobProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeSentimentDetectionJobResponse::sentimentDetectionJobProperties))
            .setter(setter(Builder::sentimentDetectionJobProperties))
            .constructor(SentimentDetectionJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentimentDetectionJobProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SENTIMENT_DETECTION_JOB_PROPERTIES_FIELD));

    private final SentimentDetectionJobProperties sentimentDetectionJobProperties;

    private DescribeSentimentDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.sentimentDetectionJobProperties = builder.sentimentDetectionJobProperties;
    }

    /**
     * <p>
     * An object that contains the properties associated with a sentiment detection job.
     * </p>
     * 
     * @return An object that contains the properties associated with a sentiment detection job.
     */
    public SentimentDetectionJobProperties sentimentDetectionJobProperties() {
        return sentimentDetectionJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sentimentDetectionJobProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSentimentDetectionJobResponse)) {
            return false;
        }
        DescribeSentimentDetectionJobResponse other = (DescribeSentimentDetectionJobResponse) obj;
        return Objects.equals(sentimentDetectionJobProperties(), other.sentimentDetectionJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSentimentDetectionJobResponse")
                .add("SentimentDetectionJobProperties", sentimentDetectionJobProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SentimentDetectionJobProperties":
            return Optional.ofNullable(clazz.cast(sentimentDetectionJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSentimentDetectionJobResponse, T> g) {
        return obj -> g.apply((DescribeSentimentDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSentimentDetectionJobResponse> {
        /**
         * <p>
         * An object that contains the properties associated with a sentiment detection job.
         * </p>
         * 
         * @param sentimentDetectionJobProperties
         *        An object that contains the properties associated with a sentiment detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentimentDetectionJobProperties(SentimentDetectionJobProperties sentimentDetectionJobProperties);

        /**
         * <p>
         * An object that contains the properties associated with a sentiment detection job.
         * </p>
         * This is a convenience that creates an instance of the {@link SentimentDetectionJobProperties.Builder}
         * avoiding the need to create one manually via {@link SentimentDetectionJobProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SentimentDetectionJobProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sentimentDetectionJobProperties(SentimentDetectionJobProperties)}.
         * 
         * @param sentimentDetectionJobProperties
         *        a consumer that will call methods on {@link SentimentDetectionJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sentimentDetectionJobProperties(SentimentDetectionJobProperties)
         */
        default Builder sentimentDetectionJobProperties(
                Consumer<SentimentDetectionJobProperties.Builder> sentimentDetectionJobProperties) {
            return sentimentDetectionJobProperties(SentimentDetectionJobProperties.builder()
                    .applyMutation(sentimentDetectionJobProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private SentimentDetectionJobProperties sentimentDetectionJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSentimentDetectionJobResponse model) {
            super(model);
            sentimentDetectionJobProperties(model.sentimentDetectionJobProperties);
        }

        public final SentimentDetectionJobProperties.Builder getSentimentDetectionJobProperties() {
            return sentimentDetectionJobProperties != null ? sentimentDetectionJobProperties.toBuilder() : null;
        }

        @Override
        public final Builder sentimentDetectionJobProperties(SentimentDetectionJobProperties sentimentDetectionJobProperties) {
            this.sentimentDetectionJobProperties = sentimentDetectionJobProperties;
            return this;
        }

        public final void setSentimentDetectionJobProperties(
                SentimentDetectionJobProperties.BuilderImpl sentimentDetectionJobProperties) {
            this.sentimentDetectionJobProperties = sentimentDetectionJobProperties != null ? sentimentDetectionJobProperties
                    .build() : null;
        }

        @Override
        public DescribeSentimentDetectionJobResponse build() {
            return new DescribeSentimentDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
