/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentClassifierFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentClassifierFilter> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DocumentClassifierFilter.getter(DocumentClassifierFilter::statusAsString)).setter(DocumentClassifierFilter.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentClassifierFilter.getter(DocumentClassifierFilter::submitTimeBefore)).setter(DocumentClassifierFilter.setter(Builder::submitTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeBefore").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DocumentClassifierFilter.getter(DocumentClassifierFilter::submitTimeAfter)).setter(DocumentClassifierFilter.setter(Builder::submitTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTimeAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SUBMIT_TIME_BEFORE_FIELD, SUBMIT_TIME_AFTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant submitTimeBefore;
    private final Instant submitTimeAfter;

    private DocumentClassifierFilter(BuilderImpl builder) {
        this.status = builder.status;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.submitTimeAfter = builder.submitTimeAfter;
    }

    public ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant submitTimeBefore() {
        return this.submitTimeBefore;
    }

    public Instant submitTimeAfter() {
        return this.submitTimeAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTimeAfter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentClassifierFilter)) {
            return false;
        }
        DocumentClassifierFilter other = (DocumentClassifierFilter)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.submitTimeBefore(), other.submitTimeBefore()) && Objects.equals(this.submitTimeAfter(), other.submitTimeAfter());
    }

    public String toString() {
        return ToString.builder((String)"DocumentClassifierFilter").add("Status", (Object)this.statusAsString()).add("SubmitTimeBefore", (Object)this.submitTimeBefore()).add("SubmitTimeAfter", (Object)this.submitTimeAfter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SubmitTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.submitTimeBefore()));
            }
            case "SubmitTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.submitTimeAfter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentClassifierFilter, T> g) {
        return obj -> g.apply((DocumentClassifierFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant submitTimeBefore;
        private Instant submitTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentClassifierFilter model) {
            this.status(model.status);
            this.submitTimeBefore(model.submitTimeBefore);
            this.submitTimeAfter(model.submitTimeAfter);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getSubmitTimeBefore() {
            return this.submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        public final Instant getSubmitTimeAfter() {
            return this.submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        public DocumentClassifierFilter build() {
            return new DocumentClassifierFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentClassifierFilter> {
        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder submitTimeBefore(Instant var1);

        public Builder submitTimeAfter(Instant var1);
    }
}

