/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.comprehend.ComprehendClient;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;

public class ListTopicsDetectionJobsIterable
implements SdkIterable<ListTopicsDetectionJobsResponse> {
    private final ComprehendClient client;
    private final ListTopicsDetectionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTopicsDetectionJobsIterable(ComprehendClient client, ListTopicsDetectionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTopicsDetectionJobsResponseFetcher();
    }

    public Iterator<ListTopicsDetectionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListTopicsDetectionJobsIterable resume(ListTopicsDetectionJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTopicsDetectionJobsIterable(this.client, (ListTopicsDetectionJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTopicsDetectionJobsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTopicsDetectionJobsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTopicsDetectionJobsResponseFetcher
    implements SyncPageFetcher<ListTopicsDetectionJobsResponse> {
        private ListTopicsDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsDetectionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTopicsDetectionJobsResponse nextPage(ListTopicsDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsDetectionJobsIterable.this.client.listTopicsDetectionJobs(ListTopicsDetectionJobsIterable.this.firstRequest);
            }
            return ListTopicsDetectionJobsIterable.this.client.listTopicsDetectionJobs((ListTopicsDetectionJobsRequest)((Object)ListTopicsDetectionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

