/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.transform.KeyPhraseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeyPhrase
implements StructuredPojo,
ToCopyableBuilder<Builder, KeyPhrase> {
    private final Float score;
    private final String text;
    private final Integer beginOffset;
    private final Integer endOffset;

    private KeyPhrase(BuilderImpl builder) {
        this.score = builder.score;
        this.text = builder.text;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
    }

    public Float score() {
        return this.score;
    }

    public String text() {
        return this.text;
    }

    public Integer beginOffset() {
        return this.beginOffset;
    }

    public Integer endOffset() {
        return this.endOffset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPhrase)) {
            return false;
        }
        KeyPhrase other = (KeyPhrase)obj;
        return Objects.equals(this.score(), other.score()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset());
    }

    public String toString() {
        return ToString.builder((String)"KeyPhrase").add("Score", (Object)this.score()).add("Text", (Object)this.text()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Score": {
                return Optional.of(clazz.cast(this.score()));
            }
            case "Text": {
                return Optional.of(clazz.cast(this.text()));
            }
            case "BeginOffset": {
                return Optional.of(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.of(clazz.cast(this.endOffset()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyPhraseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float score;
        private String text;
        private Integer beginOffset;
        private Integer endOffset;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPhrase model) {
            this.score(model.score);
            this.text(model.text);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
        }

        public final Float getScore() {
            return this.score;
        }

        @Override
        public final Builder score(Float score) {
            this.score = score;
            return this;
        }

        public final void setScore(Float score) {
            this.score = score;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public KeyPhrase build() {
            return new KeyPhrase(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyPhrase> {
        public Builder score(Float var1);

        public Builder text(String var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);
    }
}

