/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentItemResult;
import software.amazon.awssdk.services.comprehend.model.BatchItemError;
import software.amazon.awssdk.services.comprehend.model.BatchItemErrorListCopier;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.ListOfDetectSentimentResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDetectSentimentResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, BatchDetectSentimentResponse> {
    private final List<BatchDetectSentimentItemResult> resultList;
    private final List<BatchItemError> errorList;

    private BatchDetectSentimentResponse(BuilderImpl builder) {
        super(builder);
        this.resultList = builder.resultList;
        this.errorList = builder.errorList;
    }

    public List<BatchDetectSentimentItemResult> resultList() {
        return this.resultList;
    }

    public List<BatchItemError> errorList() {
        return this.errorList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultList());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSentimentResponse)) {
            return false;
        }
        BatchDetectSentimentResponse other = (BatchDetectSentimentResponse)((Object)obj);
        return Objects.equals(this.resultList(), other.resultList()) && Objects.equals(this.errorList(), other.errorList());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectSentimentResponse").add("ResultList", this.resultList()).add("ErrorList", this.errorList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultList": {
                return Optional.of(clazz.cast(this.resultList()));
            }
            case "ErrorList": {
                return Optional.of(clazz.cast(this.errorList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<BatchDetectSentimentItemResult> resultList;
        private List<BatchItemError> errorList;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSentimentResponse model) {
            this.resultList(model.resultList);
            this.errorList(model.errorList);
        }

        public final Collection<BatchDetectSentimentItemResult.Builder> getResultList() {
            return this.resultList != null ? (Collection)this.resultList.stream().map(BatchDetectSentimentItemResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resultList(Collection<BatchDetectSentimentItemResult> resultList) {
            this.resultList = ListOfDetectSentimentResultCopier.copy(resultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultList(BatchDetectSentimentItemResult ... resultList) {
            this.resultList(Arrays.asList(resultList));
            return this;
        }

        public final void setResultList(Collection<BatchDetectSentimentItemResult.BuilderImpl> resultList) {
            this.resultList = ListOfDetectSentimentResultCopier.copyFromBuilder(resultList);
        }

        public final Collection<BatchItemError.Builder> getErrorList() {
            return this.errorList != null ? (Collection)this.errorList.stream().map(BatchItemError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errorList(Collection<BatchItemError> errorList) {
            this.errorList = BatchItemErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(BatchItemError ... errorList) {
            this.errorList(Arrays.asList(errorList));
            return this;
        }

        public final void setErrorList(Collection<BatchItemError.BuilderImpl> errorList) {
            this.errorList = BatchItemErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        public BatchDetectSentimentResponse build() {
            return new BatchDetectSentimentResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, BatchDetectSentimentResponse> {
        public Builder resultList(Collection<BatchDetectSentimentItemResult> var1);

        public Builder resultList(BatchDetectSentimentItemResult ... var1);

        public Builder errorList(Collection<BatchItemError> var1);

        public Builder errorList(BatchItemError ... var1);
    }
}

