/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.comprehend.model.SyntaxToken;
import software.amazon.awssdk.services.comprehend.transform.PartOfSpeechTagUnmarshaller;

public class SyntaxTokenUnmarshaller
implements Unmarshaller<SyntaxToken, JsonUnmarshallerContext> {
    private static final SyntaxTokenUnmarshaller INSTANCE = new SyntaxTokenUnmarshaller();

    public SyntaxToken unmarshall(JsonUnmarshallerContext context) throws Exception {
        SyntaxToken.Builder syntaxTokenBuilder = SyntaxToken.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TokenId", targetDepth)) {
                    context.nextToken();
                    syntaxTokenBuilder.tokenId((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Text", targetDepth)) {
                    context.nextToken();
                    syntaxTokenBuilder.text((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BeginOffset", targetDepth)) {
                    context.nextToken();
                    syntaxTokenBuilder.beginOffset((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndOffset", targetDepth)) {
                    context.nextToken();
                    syntaxTokenBuilder.endOffset((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("PartOfSpeech", targetDepth)) {
                    context.nextToken();
                    syntaxTokenBuilder.partOfSpeech(PartOfSpeechTagUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SyntaxToken)syntaxTokenBuilder.build();
    }

    public static SyntaxTokenUnmarshaller getInstance() {
        return INSTANCE;
    }
}

