/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.SentimentDetectionJobFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SentimentDetectionJobFilterMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIMEBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTimeBefore").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIMEAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTimeAfter").isBinary(false).build();
    private static final SentimentDetectionJobFilterMarshaller INSTANCE = new SentimentDetectionJobFilterMarshaller();

    private SentimentDetectionJobFilterMarshaller() {
    }

    public static SentimentDetectionJobFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SentimentDetectionJobFilter sentimentDetectionJobFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sentimentDetectionJobFilter, (String)"sentimentDetectionJobFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sentimentDetectionJobFilter.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobFilter.jobStatusAsString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobFilter.submitTimeBefore(), SUBMITTIMEBEFORE_BINDING);
            protocolMarshaller.marshall((Object)sentimentDetectionJobFilter.submitTimeAfter(), SUBMITTIMEAFTER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

