/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DominantLanguageDetectionJobFilterMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIMEBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTimeBefore").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIMEAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTimeAfter").isBinary(false).build();
    private static final DominantLanguageDetectionJobFilterMarshaller INSTANCE = new DominantLanguageDetectionJobFilterMarshaller();

    private DominantLanguageDetectionJobFilterMarshaller() {
    }

    public static DominantLanguageDetectionJobFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DominantLanguageDetectionJobFilter dominantLanguageDetectionJobFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dominantLanguageDetectionJobFilter, (String)"dominantLanguageDetectionJobFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobFilter.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobFilter.jobStatusAsString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobFilter.submitTimeBefore(), SUBMITTIMEBEFORE_BINDING);
            protocolMarshaller.marshall((Object)dominantLanguageDetectionJobFilter.submitTimeAfter(), SUBMITTIMEAFTER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

