/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.PartOfSpeechTag;
import software.amazon.awssdk.services.comprehend.transform.SyntaxTokenMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyntaxToken
implements StructuredPojo,
ToCopyableBuilder<Builder, SyntaxToken> {
    private final Integer tokenId;
    private final String text;
    private final Integer beginOffset;
    private final Integer endOffset;
    private final PartOfSpeechTag partOfSpeech;

    private SyntaxToken(BuilderImpl builder) {
        this.tokenId = builder.tokenId;
        this.text = builder.text;
        this.beginOffset = builder.beginOffset;
        this.endOffset = builder.endOffset;
        this.partOfSpeech = builder.partOfSpeech;
    }

    public Integer tokenId() {
        return this.tokenId;
    }

    public String text() {
        return this.text;
    }

    public Integer beginOffset() {
        return this.beginOffset;
    }

    public Integer endOffset() {
        return this.endOffset;
    }

    public PartOfSpeechTag partOfSpeech() {
        return this.partOfSpeech;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.partOfSpeech());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyntaxToken)) {
            return false;
        }
        SyntaxToken other = (SyntaxToken)obj;
        return Objects.equals(this.tokenId(), other.tokenId()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.beginOffset(), other.beginOffset()) && Objects.equals(this.endOffset(), other.endOffset()) && Objects.equals(this.partOfSpeech(), other.partOfSpeech());
    }

    public String toString() {
        return ToString.builder((String)"SyntaxToken").add("TokenId", (Object)this.tokenId()).add("Text", (Object)this.text()).add("BeginOffset", (Object)this.beginOffset()).add("EndOffset", (Object)this.endOffset()).add("PartOfSpeech", (Object)this.partOfSpeech()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TokenId": {
                return Optional.ofNullable(clazz.cast(this.tokenId()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "BeginOffset": {
                return Optional.ofNullable(clazz.cast(this.beginOffset()));
            }
            case "EndOffset": {
                return Optional.ofNullable(clazz.cast(this.endOffset()));
            }
            case "PartOfSpeech": {
                return Optional.ofNullable(clazz.cast(this.partOfSpeech()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SyntaxTokenMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer tokenId;
        private String text;
        private Integer beginOffset;
        private Integer endOffset;
        private PartOfSpeechTag partOfSpeech;

        private BuilderImpl() {
        }

        private BuilderImpl(SyntaxToken model) {
            this.tokenId(model.tokenId);
            this.text(model.text);
            this.beginOffset(model.beginOffset);
            this.endOffset(model.endOffset);
            this.partOfSpeech(model.partOfSpeech);
        }

        public final Integer getTokenId() {
            return this.tokenId;
        }

        @Override
        public final Builder tokenId(Integer tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final void setTokenId(Integer tokenId) {
            this.tokenId = tokenId;
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final Integer getBeginOffset() {
            return this.beginOffset;
        }

        @Override
        public final Builder beginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
            return this;
        }

        public final void setBeginOffset(Integer beginOffset) {
            this.beginOffset = beginOffset;
        }

        public final Integer getEndOffset() {
            return this.endOffset;
        }

        @Override
        public final Builder endOffset(Integer endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        public final void setEndOffset(Integer endOffset) {
            this.endOffset = endOffset;
        }

        public final PartOfSpeechTag.Builder getPartOfSpeech() {
            return this.partOfSpeech != null ? this.partOfSpeech.toBuilder() : null;
        }

        @Override
        public final Builder partOfSpeech(PartOfSpeechTag partOfSpeech) {
            this.partOfSpeech = partOfSpeech;
            return this;
        }

        public final void setPartOfSpeech(PartOfSpeechTag.BuilderImpl partOfSpeech) {
            this.partOfSpeech = partOfSpeech != null ? partOfSpeech.build() : null;
        }

        public SyntaxToken build() {
            return new SyntaxToken(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SyntaxToken> {
        public Builder tokenId(Integer var1);

        public Builder text(String var1);

        public Builder beginOffset(Integer var1);

        public Builder endOffset(Integer var1);

        public Builder partOfSpeech(PartOfSpeechTag var1);

        default public Builder partOfSpeech(Consumer<PartOfSpeechTag.Builder> partOfSpeech) {
            return this.partOfSpeech((PartOfSpeechTag)((PartOfSpeechTag.Builder)PartOfSpeechTag.builder().applyMutation(partOfSpeech)).build());
        }
    }
}

