/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.EntitiesDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.EntitiesDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListEntitiesDetectionJobsResponse> {
    private final List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList;
    private final String nextToken;

    private ListEntitiesDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.entitiesDetectionJobPropertiesList = builder.entitiesDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList() {
        return this.entitiesDetectionJobPropertiesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entitiesDetectionJobPropertiesList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesDetectionJobsResponse)) {
            return false;
        }
        ListEntitiesDetectionJobsResponse other = (ListEntitiesDetectionJobsResponse)((Object)obj);
        return Objects.equals(this.entitiesDetectionJobPropertiesList(), other.entitiesDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEntitiesDetectionJobsResponse").add("EntitiesDetectionJobPropertiesList", this.entitiesDetectionJobPropertiesList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntitiesDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.entitiesDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesDetectionJobsResponse model) {
            super(model);
            this.entitiesDetectionJobPropertiesList(model.entitiesDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<EntitiesDetectionJobProperties.Builder> getEntitiesDetectionJobPropertiesList() {
            return this.entitiesDetectionJobPropertiesList != null ? (Collection)this.entitiesDetectionJobPropertiesList.stream().map(EntitiesDetectionJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entitiesDetectionJobPropertiesList(Collection<EntitiesDetectionJobProperties> entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList = EntitiesDetectionJobPropertiesListCopier.copy(entitiesDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitiesDetectionJobPropertiesList(EntitiesDetectionJobProperties ... entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList(Arrays.asList(entitiesDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitiesDetectionJobPropertiesList(Consumer<EntitiesDetectionJobProperties.Builder> ... entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList(Stream.of(entitiesDetectionJobPropertiesList).map(c -> (EntitiesDetectionJobProperties)((EntitiesDetectionJobProperties.Builder)EntitiesDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntitiesDetectionJobPropertiesList(Collection<EntitiesDetectionJobProperties.BuilderImpl> entitiesDetectionJobPropertiesList) {
            this.entitiesDetectionJobPropertiesList = EntitiesDetectionJobPropertiesListCopier.copyFromBuilder(entitiesDetectionJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEntitiesDetectionJobsResponse build() {
            return new ListEntitiesDetectionJobsResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, ListEntitiesDetectionJobsResponse> {
        public Builder entitiesDetectionJobPropertiesList(Collection<EntitiesDetectionJobProperties> var1);

        public Builder entitiesDetectionJobPropertiesList(EntitiesDetectionJobProperties ... var1);

        public Builder entitiesDetectionJobPropertiesList(Consumer<EntitiesDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

