/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.ComprehendResponse;
import software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobProperties;
import software.amazon.awssdk.services.comprehend.model.DominantLanguageDetectionJobPropertiesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDominantLanguageDetectionJobsResponse
extends ComprehendResponse
implements ToCopyableBuilder<Builder, ListDominantLanguageDetectionJobsResponse> {
    private final List<DominantLanguageDetectionJobProperties> dominantLanguageDetectionJobPropertiesList;
    private final String nextToken;

    private ListDominantLanguageDetectionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.dominantLanguageDetectionJobPropertiesList = builder.dominantLanguageDetectionJobPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public List<DominantLanguageDetectionJobProperties> dominantLanguageDetectionJobPropertiesList() {
        return this.dominantLanguageDetectionJobPropertiesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dominantLanguageDetectionJobPropertiesList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDominantLanguageDetectionJobsResponse)) {
            return false;
        }
        ListDominantLanguageDetectionJobsResponse other = (ListDominantLanguageDetectionJobsResponse)((Object)obj);
        return Objects.equals(this.dominantLanguageDetectionJobPropertiesList(), other.dominantLanguageDetectionJobPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDominantLanguageDetectionJobsResponse").add("DominantLanguageDetectionJobPropertiesList", this.dominantLanguageDetectionJobPropertiesList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DominantLanguageDetectionJobPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.dominantLanguageDetectionJobPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ComprehendResponse.BuilderImpl
    implements Builder {
        private List<DominantLanguageDetectionJobProperties> dominantLanguageDetectionJobPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDominantLanguageDetectionJobsResponse model) {
            super(model);
            this.dominantLanguageDetectionJobPropertiesList(model.dominantLanguageDetectionJobPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final Collection<DominantLanguageDetectionJobProperties.Builder> getDominantLanguageDetectionJobPropertiesList() {
            return this.dominantLanguageDetectionJobPropertiesList != null ? (Collection)this.dominantLanguageDetectionJobPropertiesList.stream().map(DominantLanguageDetectionJobProperties::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dominantLanguageDetectionJobPropertiesList(Collection<DominantLanguageDetectionJobProperties> dominantLanguageDetectionJobPropertiesList) {
            this.dominantLanguageDetectionJobPropertiesList = DominantLanguageDetectionJobPropertiesListCopier.copy(dominantLanguageDetectionJobPropertiesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantLanguageDetectionJobPropertiesList(DominantLanguageDetectionJobProperties ... dominantLanguageDetectionJobPropertiesList) {
            this.dominantLanguageDetectionJobPropertiesList(Arrays.asList(dominantLanguageDetectionJobPropertiesList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dominantLanguageDetectionJobPropertiesList(Consumer<DominantLanguageDetectionJobProperties.Builder> ... dominantLanguageDetectionJobPropertiesList) {
            this.dominantLanguageDetectionJobPropertiesList(Stream.of(dominantLanguageDetectionJobPropertiesList).map(c -> (DominantLanguageDetectionJobProperties)((DominantLanguageDetectionJobProperties.Builder)DominantLanguageDetectionJobProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDominantLanguageDetectionJobPropertiesList(Collection<DominantLanguageDetectionJobProperties.BuilderImpl> dominantLanguageDetectionJobPropertiesList) {
            this.dominantLanguageDetectionJobPropertiesList = DominantLanguageDetectionJobPropertiesListCopier.copyFromBuilder(dominantLanguageDetectionJobPropertiesList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDominantLanguageDetectionJobsResponse build() {
            return new ListDominantLanguageDetectionJobsResponse(this);
        }
    }

    public static interface Builder
    extends ComprehendResponse.Builder,
    CopyableBuilder<Builder, ListDominantLanguageDetectionJobsResponse> {
        public Builder dominantLanguageDetectionJobPropertiesList(Collection<DominantLanguageDetectionJobProperties> var1);

        public Builder dominantLanguageDetectionJobPropertiesList(DominantLanguageDetectionJobProperties ... var1);

        public Builder dominantLanguageDetectionJobPropertiesList(Consumer<DominantLanguageDetectionJobProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

