/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.comprehend.model.TopicsDetectionJobFilter;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TopicsDetectionJobFilterMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobStatus").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIMEBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTimeBefore").isBinary(false).build();
    private static final MarshallingInfo<Instant> SUBMITTIMEAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmitTimeAfter").isBinary(false).build();
    private static final TopicsDetectionJobFilterMarshaller INSTANCE = new TopicsDetectionJobFilterMarshaller();

    private TopicsDetectionJobFilterMarshaller() {
    }

    public static TopicsDetectionJobFilterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TopicsDetectionJobFilter topicsDetectionJobFilter, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)topicsDetectionJobFilter, (String)"topicsDetectionJobFilter");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)topicsDetectionJobFilter.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobFilter.jobStatusAsString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobFilter.submitTimeBefore(), SUBMITTIMEBEFORE_BINDING);
            protocolMarshaller.marshall((Object)topicsDetectionJobFilter.submitTimeAfter(), SUBMITTIMEAFTER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

