/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest;
import software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsResponse;

public class ListTopicsDetectionJobsPublisher
implements SdkPublisher<ListTopicsDetectionJobsResponse> {
    private final ComprehendAsyncClient client;
    private final ListTopicsDetectionJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTopicsDetectionJobsPublisher(ComprehendAsyncClient client, ListTopicsDetectionJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTopicsDetectionJobsPublisher(ComprehendAsyncClient client, ListTopicsDetectionJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTopicsDetectionJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTopicsDetectionJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListTopicsDetectionJobsPublisher resume(ListTopicsDetectionJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTopicsDetectionJobsPublisher(this.client, (ListTopicsDetectionJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTopicsDetectionJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTopicsDetectionJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTopicsDetectionJobsResponseFetcher
    implements AsyncPageFetcher<ListTopicsDetectionJobsResponse> {
        private ListTopicsDetectionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsDetectionJobsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListTopicsDetectionJobsResponse> nextPage(ListTopicsDetectionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsDetectionJobsPublisher.this.client.listTopicsDetectionJobs(ListTopicsDetectionJobsPublisher.this.firstRequest);
            }
            return ListTopicsDetectionJobsPublisher.this.client.listTopicsDetectionJobs((ListTopicsDetectionJobsRequest)((Object)ListTopicsDetectionJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

