/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.comprehend.model.SentimentScore;
import software.amazon.awssdk.services.comprehend.model.SentimentType;
import software.amazon.awssdk.services.comprehend.transform.BatchDetectSentimentItemResultMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDetectSentimentItemResult
implements StructuredPojo,
ToCopyableBuilder<Builder, BatchDetectSentimentItemResult> {
    private final Integer index;
    private final String sentiment;
    private final SentimentScore sentimentScore;

    private BatchDetectSentimentItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.sentiment = builder.sentiment;
        this.sentimentScore = builder.sentimentScore;
    }

    public Integer index() {
        return this.index;
    }

    public SentimentType sentiment() {
        return SentimentType.fromValue(this.sentiment);
    }

    public String sentimentAsString() {
        return this.sentiment;
    }

    public SentimentScore sentimentScore() {
        return this.sentimentScore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentimentScore());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectSentimentItemResult)) {
            return false;
        }
        BatchDetectSentimentItemResult other = (BatchDetectSentimentItemResult)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.sentimentAsString(), other.sentimentAsString()) && Objects.equals(this.sentimentScore(), other.sentimentScore());
    }

    public String toString() {
        return ToString.builder((String)"BatchDetectSentimentItemResult").add("Index", (Object)this.index()).add("Sentiment", (Object)this.sentimentAsString()).add("SentimentScore", (Object)this.sentimentScore()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.of(clazz.cast(this.index()));
            }
            case "Sentiment": {
                return Optional.of(clazz.cast(this.sentimentAsString()));
            }
            case "SentimentScore": {
                return Optional.of(clazz.cast(this.sentimentScore()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchDetectSentimentItemResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private String sentiment;
        private SentimentScore sentimentScore;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectSentimentItemResult model) {
            this.index(model.index);
            this.sentiment(model.sentiment);
            this.sentimentScore(model.sentimentScore);
        }

        public final Integer getIndex() {
            return this.index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        public final String getSentiment() {
            return this.sentiment;
        }

        @Override
        public final Builder sentiment(String sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        @Override
        public final Builder sentiment(SentimentType sentiment) {
            this.sentiment(sentiment.toString());
            return this;
        }

        public final void setSentiment(String sentiment) {
            this.sentiment = sentiment;
        }

        public final SentimentScore.Builder getSentimentScore() {
            return this.sentimentScore != null ? this.sentimentScore.toBuilder() : null;
        }

        @Override
        public final Builder sentimentScore(SentimentScore sentimentScore) {
            this.sentimentScore = sentimentScore;
            return this;
        }

        public final void setSentimentScore(SentimentScore.BuilderImpl sentimentScore) {
            this.sentimentScore = sentimentScore != null ? sentimentScore.build() : null;
        }

        public BatchDetectSentimentItemResult build() {
            return new BatchDetectSentimentItemResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchDetectSentimentItemResult> {
        public Builder index(Integer var1);

        public Builder sentiment(String var1);

        public Builder sentiment(SentimentType var1);

        public Builder sentimentScore(SentimentScore var1);

        default public Builder sentimentScore(Consumer<SentimentScore.Builder> sentimentScore) {
            return this.sentimentScore((SentimentScore)((SentimentScore.Builder)SentimentScore.builder().apply(sentimentScore)).build());
        }
    }
}

