/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Operation {
    REPLACE("replace"),
    REMOVE("remove"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Operation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Operation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Operation.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Operation> knownValues() {
        return Stream.of(Operation.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

