/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cognitosync.CognitoSyncAsyncClient;
import software.amazon.awssdk.services.cognitosync.CognitoSyncServiceClientConfiguration;
import software.amazon.awssdk.services.cognitosync.internal.CognitoSyncServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cognitosync.model.AlreadyStreamedException;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncException;
import software.amazon.awssdk.services.cognitosync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DuplicateRequestException;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.InternalErrorException;
import software.amazon.awssdk.services.cognitosync.model.InvalidConfigurationException;
import software.amazon.awssdk.services.cognitosync.model.InvalidLambdaFunctionOutputException;
import software.amazon.awssdk.services.cognitosync.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitosync.model.LambdaThrottledException;
import software.amazon.awssdk.services.cognitosync.model.LimitExceededException;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse;
import software.amazon.awssdk.services.cognitosync.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse;
import software.amazon.awssdk.services.cognitosync.model.ResourceConflictException;
import software.amazon.awssdk.services.cognitosync.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse;
import software.amazon.awssdk.services.cognitosync.transform.BulkPublishRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetBulkPublishDetailsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetCognitoEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetIdentityPoolConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListIdentityPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListRecordsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.RegisterDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetCognitoEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetIdentityPoolConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SubscribeToDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UnsubscribeFromDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UpdateRecordsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCognitoSyncAsyncClient
implements CognitoSyncAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCognitoSyncAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoSyncAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Cognito_Sync#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BulkPublishResponse> bulkPublish(BulkPublishRequest bulkPublishRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)bulkPublishRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, bulkPublishRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BulkPublish");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BulkPublishResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BulkPublish").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BulkPublishRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)bulkPublishRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$bulkPublish$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$bulkPublish$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$deleteDataset$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$deleteDataset$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, describeDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$describeDataset$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$describeDataset$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeIdentityPoolUsageResponse> describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIdentityPoolUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, describeIdentityPoolUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityPoolUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityPoolUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityPoolUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeIdentityPoolUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeIdentityPoolUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$describeIdentityPoolUsage$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$describeIdentityPoolUsage$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeIdentityUsageResponse> describeIdentityUsage(DescribeIdentityUsageRequest describeIdentityUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeIdentityUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, describeIdentityUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeIdentityUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeIdentityUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$describeIdentityUsage$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$describeIdentityUsage$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBulkPublishDetailsResponse> getBulkPublishDetails(GetBulkPublishDetailsRequest getBulkPublishDetailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getBulkPublishDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, getBulkPublishDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBulkPublishDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBulkPublishDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBulkPublishDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetBulkPublishDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getBulkPublishDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$getBulkPublishDetails$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$getBulkPublishDetails$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCognitoEventsResponse> getCognitoEvents(GetCognitoEventsRequest getCognitoEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCognitoEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, getCognitoEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCognitoEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCognitoEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCognitoEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCognitoEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCognitoEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$getCognitoEvents$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$getCognitoEvents$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetIdentityPoolConfigurationResponse> getIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIdentityPoolConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, getIdentityPoolConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityPoolConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdentityPoolConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityPoolConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetIdentityPoolConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getIdentityPoolConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$getIdentityPoolConfiguration$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$getIdentityPoolConfiguration$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDatasetsResponse> listDatasets(ListDatasetsRequest listDatasetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatasetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, listDatasetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDatasetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$listDatasets$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$listDatasets$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIdentityPoolUsageResponse> listIdentityPoolUsage(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listIdentityPoolUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, listIdentityPoolUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityPoolUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityPoolUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityPoolUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListIdentityPoolUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIdentityPoolUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$listIdentityPoolUsage$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$listIdentityPoolUsage$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRecordsResponse> listRecords(ListRecordsRequest listRecordsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, listRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecordsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$listRecords$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$listRecords$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RegisterDeviceResponse> registerDevice(RegisterDeviceRequest registerDeviceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, registerDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterDevice");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterDeviceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RegisterDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)registerDeviceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$registerDevice$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$registerDevice$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetCognitoEventsResponse> setCognitoEvents(SetCognitoEventsRequest setCognitoEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setCognitoEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, setCognitoEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetCognitoEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetCognitoEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetCognitoEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetCognitoEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setCognitoEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$setCognitoEvents$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$setCognitoEvents$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetIdentityPoolConfigurationResponse> setIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)setIdentityPoolConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, setIdentityPoolConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityPoolConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetIdentityPoolConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityPoolConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SetIdentityPoolConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setIdentityPoolConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$setIdentityPoolConfiguration$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$setIdentityPoolConfiguration$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SubscribeToDatasetResponse> subscribeToDataset(SubscribeToDatasetRequest subscribeToDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)subscribeToDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, subscribeToDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SubscribeToDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SubscribeToDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SubscribeToDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SubscribeToDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)subscribeToDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$subscribeToDataset$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$subscribeToDataset$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UnsubscribeFromDatasetResponse> unsubscribeFromDataset(UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)unsubscribeFromDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, unsubscribeFromDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnsubscribeFromDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnsubscribeFromDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnsubscribeFromDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UnsubscribeFromDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)unsubscribeFromDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$unsubscribeFromDataset$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$unsubscribeFromDataset$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRecordsResponse> updateRecords(UpdateRecordsRequest updateRecordsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCognitoSyncAsyncClient.resolveMetricPublishers(clientConfiguration, updateRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Sync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRecordsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidConfigurationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                    }
                    case "InvalidParameterException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "DuplicateRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                    }
                    case "ResourceConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceConflictException::builder).build());
                    }
                    case "LambdaThrottledException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LambdaThrottledException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(LambdaThrottledException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                    case "InternalErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalErrorException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "InvalidLambdaFunctionOutputException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionOutputException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLambdaFunctionOutputException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "AlreadyStreamedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AlreadyStreamedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AlreadyStreamedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCognitoSyncAsyncClient.lambda$updateRecords$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCognitoSyncAsyncClient.lambda$updateRecords$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CognitoSyncServiceClientConfiguration serviceClientConfiguration() {
        return new CognitoSyncServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "cognito-sync";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CognitoSyncException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CognitoSyncServiceClientConfigurationBuilder serviceConfigBuilder = new CognitoSyncServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRecords$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRecords$66(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$unsubscribeFromDataset$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unsubscribeFromDataset$62(List metricPublishers, MetricCollector apiCallMetricCollector, UnsubscribeFromDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$subscribeToDataset$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$subscribeToDataset$58(List metricPublishers, MetricCollector apiCallMetricCollector, SubscribeToDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setIdentityPoolConfiguration$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityPoolConfiguration$54(List metricPublishers, MetricCollector apiCallMetricCollector, SetIdentityPoolConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setCognitoEvents$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setCognitoEvents$50(List metricPublishers, MetricCollector apiCallMetricCollector, SetCognitoEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$registerDevice$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerDevice$46(List metricPublishers, MetricCollector apiCallMetricCollector, RegisterDeviceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRecords$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecords$42(List metricPublishers, MetricCollector apiCallMetricCollector, ListRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listIdentityPoolUsage$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityPoolUsage$38(List metricPublishers, MetricCollector apiCallMetricCollector, ListIdentityPoolUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDatasets$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasets$34(List metricPublishers, MetricCollector apiCallMetricCollector, ListDatasetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getIdentityPoolConfiguration$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityPoolConfiguration$30(List metricPublishers, MetricCollector apiCallMetricCollector, GetIdentityPoolConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCognitoEvents$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCognitoEvents$26(List metricPublishers, MetricCollector apiCallMetricCollector, GetCognitoEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBulkPublishDetails$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBulkPublishDetails$22(List metricPublishers, MetricCollector apiCallMetricCollector, GetBulkPublishDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeIdentityUsage$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityUsage$18(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeIdentityUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeIdentityPoolUsage$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityPoolUsage$14(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeIdentityPoolUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataset$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataset$10(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDataset$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataset$6(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$bulkPublish$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$bulkPublish$2(List metricPublishers, MetricCollector apiCallMetricCollector, BulkPublishResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

