/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitosync.model.StreamingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CognitoStreams
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CognitoStreams> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CognitoStreams.getter(CognitoStreams::streamName)).setter(CognitoStreams.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CognitoStreams.getter(CognitoStreams::roleArn)).setter(CognitoStreams.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> STREAMING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CognitoStreams.getter(CognitoStreams::streamingStatusAsString)).setter(CognitoStreams.setter(Builder::streamingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, ROLE_ARN_FIELD, STREAMING_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String streamName;
    private final String roleArn;
    private final String streamingStatus;

    private CognitoStreams(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.roleArn = builder.roleArn;
        this.streamingStatus = builder.streamingStatus;
    }

    public String streamName() {
        return this.streamName;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public StreamingStatus streamingStatus() {
        return StreamingStatus.fromValue(this.streamingStatus);
    }

    public String streamingStatusAsString() {
        return this.streamingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoStreams)) {
            return false;
        }
        CognitoStreams other = (CognitoStreams)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.streamingStatusAsString(), other.streamingStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"CognitoStreams").add("StreamName", (Object)this.streamName()).add("RoleArn", (Object)this.roleArn()).add("StreamingStatus", (Object)this.streamingStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "StreamingStatus": {
                return Optional.ofNullable(clazz.cast(this.streamingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoStreams, T> g) {
        return obj -> g.apply((CognitoStreams)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String roleArn;
        private String streamingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoStreams model) {
            this.streamName(model.streamName);
            this.roleArn(model.roleArn);
            this.streamingStatus(model.streamingStatus);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamingStatus() {
            return this.streamingStatus;
        }

        @Override
        public final Builder streamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
            return this;
        }

        @Override
        public final Builder streamingStatus(StreamingStatus streamingStatus) {
            this.streamingStatus(streamingStatus.toString());
            return this;
        }

        public final void setStreamingStatus(String streamingStatus) {
            this.streamingStatus = streamingStatus;
        }

        public CognitoStreams build() {
            return new CognitoStreams(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CognitoStreams> {
        public Builder streamName(String var1);

        public Builder roleArn(String var1);

        public Builder streamingStatus(String var1);

        public Builder streamingStatus(StreamingStatus var1);
    }
}

