/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.services.cognitosync.model.EventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCognitoEventsResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, GetCognitoEventsResponse> {
    private static final SdkField<Map<String, String>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Events").getter(GetCognitoEventsResponse.getter(GetCognitoEventsResponse::events)).setter(GetCognitoEventsResponse.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD));
    private final Map<String, String> events;

    private GetCognitoEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCognitoEventsResponse)) {
            return false;
        }
        GetCognitoEventsResponse other = (GetCognitoEventsResponse)((Object)obj);
        return this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events());
    }

    public final String toString() {
        return ToString.builder((String)"GetCognitoEventsResponse").add("Events", this.hasEvents() ? this.events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCognitoEventsResponse, T> g) {
        return obj -> g.apply((GetCognitoEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private Map<String, String> events = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCognitoEventsResponse model) {
            super(model);
            this.events(model.events);
        }

        public final Map<String, String> getEvents() {
            if (this.events instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.events;
        }

        public final void setEvents(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
        }

        @Override
        @Transient
        public final Builder events(Map<String, String> events) {
            this.events = EventsCopier.copy(events);
            return this;
        }

        @Override
        public GetCognitoEventsResponse build() {
            return new GetCognitoEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCognitoEventsResponse> {
        public Builder events(Map<String, String> var1);
    }
}

