/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitosync.model.CognitoStreams;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.services.cognitosync.model.PushSync;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetIdentityPoolConfigurationResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, SetIdentityPoolConfigurationResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(SetIdentityPoolConfigurationResponse.getter(SetIdentityPoolConfigurationResponse::identityPoolId)).setter(SetIdentityPoolConfigurationResponse.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<PushSync> PUSH_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PushSync").getter(SetIdentityPoolConfigurationResponse.getter(SetIdentityPoolConfigurationResponse::pushSync)).setter(SetIdentityPoolConfigurationResponse.setter(Builder::pushSync)).constructor(PushSync::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PushSync").build()}).build();
    private static final SdkField<CognitoStreams> COGNITO_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoStreams").getter(SetIdentityPoolConfigurationResponse.getter(SetIdentityPoolConfigurationResponse::cognitoStreams)).setter(SetIdentityPoolConfigurationResponse.setter(Builder::cognitoStreams)).constructor(CognitoStreams::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoStreams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, PUSH_SYNC_FIELD, COGNITO_STREAMS_FIELD));
    private final String identityPoolId;
    private final PushSync pushSync;
    private final CognitoStreams cognitoStreams;

    private SetIdentityPoolConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.pushSync = builder.pushSync;
        this.cognitoStreams = builder.cognitoStreams;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final PushSync pushSync() {
        return this.pushSync;
    }

    public final CognitoStreams cognitoStreams() {
        return this.cognitoStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pushSync());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoStreams());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityPoolConfigurationResponse)) {
            return false;
        }
        SetIdentityPoolConfigurationResponse other = (SetIdentityPoolConfigurationResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.pushSync(), other.pushSync()) && Objects.equals(this.cognitoStreams(), other.cognitoStreams());
    }

    public final String toString() {
        return ToString.builder((String)"SetIdentityPoolConfigurationResponse").add("IdentityPoolId", (Object)this.identityPoolId()).add("PushSync", (Object)this.pushSync()).add("CognitoStreams", (Object)this.cognitoStreams()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "PushSync": {
                return Optional.ofNullable(clazz.cast(this.pushSync()));
            }
            case "CognitoStreams": {
                return Optional.ofNullable(clazz.cast(this.cognitoStreams()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetIdentityPoolConfigurationResponse, T> g) {
        return obj -> g.apply((SetIdentityPoolConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private PushSync pushSync;
        private CognitoStreams cognitoStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityPoolConfigurationResponse model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.pushSync(model.pushSync);
            this.cognitoStreams(model.cognitoStreams);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        @Transient
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final PushSync.Builder getPushSync() {
            return this.pushSync != null ? this.pushSync.toBuilder() : null;
        }

        public final void setPushSync(PushSync.BuilderImpl pushSync) {
            this.pushSync = pushSync != null ? pushSync.build() : null;
        }

        @Override
        @Transient
        public final Builder pushSync(PushSync pushSync) {
            this.pushSync = pushSync;
            return this;
        }

        public final CognitoStreams.Builder getCognitoStreams() {
            return this.cognitoStreams != null ? this.cognitoStreams.toBuilder() : null;
        }

        public final void setCognitoStreams(CognitoStreams.BuilderImpl cognitoStreams) {
            this.cognitoStreams = cognitoStreams != null ? cognitoStreams.build() : null;
        }

        @Override
        @Transient
        public final Builder cognitoStreams(CognitoStreams cognitoStreams) {
            this.cognitoStreams = cognitoStreams;
            return this;
        }

        @Override
        public SetIdentityPoolConfigurationResponse build() {
            return new SetIdentityPoolConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetIdentityPoolConfigurationResponse> {
        public Builder identityPoolId(String var1);

        public Builder pushSync(PushSync var1);

        default public Builder pushSync(Consumer<PushSync.Builder> pushSync) {
            return this.pushSync((PushSync)((PushSync.Builder)PushSync.builder().applyMutation(pushSync)).build());
        }

        public Builder cognitoStreams(CognitoStreams var1);

        default public Builder cognitoStreams(Consumer<CognitoStreams.Builder> cognitoStreams) {
            return this.cognitoStreams((CognitoStreams)((CognitoStreams.Builder)CognitoStreams.builder().applyMutation(cognitoStreams)).build());
        }
    }
}

