/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitosync.model.Operation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordPatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordPatch> {
    private static final SdkField<String> OP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Op").getter(RecordPatch.getter(RecordPatch::opAsString)).setter(RecordPatch.setter(Builder::op)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Op").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(RecordPatch.getter(RecordPatch::key)).setter(RecordPatch.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(RecordPatch.getter(RecordPatch::value)).setter(RecordPatch.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Long> SYNC_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SyncCount").getter(RecordPatch.getter(RecordPatch::syncCount)).setter(RecordPatch.setter(Builder::syncCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCount").build()}).build();
    private static final SdkField<Instant> DEVICE_LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeviceLastModifiedDate").getter(RecordPatch.getter(RecordPatch::deviceLastModifiedDate)).setter(RecordPatch.setter(Builder::deviceLastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceLastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OP_FIELD, KEY_FIELD, VALUE_FIELD, SYNC_COUNT_FIELD, DEVICE_LAST_MODIFIED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String op;
    private final String key;
    private final String value;
    private final Long syncCount;
    private final Instant deviceLastModifiedDate;

    private RecordPatch(BuilderImpl builder) {
        this.op = builder.op;
        this.key = builder.key;
        this.value = builder.value;
        this.syncCount = builder.syncCount;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
    }

    public Operation op() {
        return Operation.fromValue(this.op);
    }

    public String opAsString() {
        return this.op;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Long syncCount() {
        return this.syncCount;
    }

    public Instant deviceLastModifiedDate() {
        return this.deviceLastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceLastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordPatch)) {
            return false;
        }
        RecordPatch other = (RecordPatch)obj;
        return Objects.equals(this.opAsString(), other.opAsString()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.syncCount(), other.syncCount()) && Objects.equals(this.deviceLastModifiedDate(), other.deviceLastModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"RecordPatch").add("Op", (Object)this.opAsString()).add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("SyncCount", (Object)this.syncCount()).add("DeviceLastModifiedDate", (Object)this.deviceLastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Op": {
                return Optional.ofNullable(clazz.cast(this.opAsString()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "SyncCount": {
                return Optional.ofNullable(clazz.cast(this.syncCount()));
            }
            case "DeviceLastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.deviceLastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordPatch, T> g) {
        return obj -> g.apply((RecordPatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String op;
        private String key;
        private String value;
        private Long syncCount;
        private Instant deviceLastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordPatch model) {
            this.op(model.op);
            this.key(model.key);
            this.value(model.value);
            this.syncCount(model.syncCount);
            this.deviceLastModifiedDate(model.deviceLastModifiedDate);
        }

        public final String getOp() {
            return this.op;
        }

        @Override
        public final Builder op(String op) {
            this.op = op;
            return this;
        }

        @Override
        public final Builder op(Operation op) {
            this.op(op == null ? null : op.toString());
            return this;
        }

        public final void setOp(String op) {
            this.op = op;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Long getSyncCount() {
            return this.syncCount;
        }

        @Override
        public final Builder syncCount(Long syncCount) {
            this.syncCount = syncCount;
            return this;
        }

        public final void setSyncCount(Long syncCount) {
            this.syncCount = syncCount;
        }

        public final Instant getDeviceLastModifiedDate() {
            return this.deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        public RecordPatch build() {
            return new RecordPatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordPatch> {
        public Builder op(String var1);

        public Builder op(Operation var1);

        public Builder key(String var1);

        public Builder value(String var1);

        public Builder syncCount(Long var1);

        public Builder deviceLastModifiedDate(Instant var1);
    }
}

