/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options to be applied to the identity pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushSync implements SdkPojo, Serializable, ToCopyableBuilder<PushSync.Builder, PushSync> {
    private static final SdkField<List<String>> APPLICATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PushSync::applicationArns))
            .setter(setter(Builder::applicationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PushSync::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARNS_FIELD,
            ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> applicationArns;

    private final String roleArn;

    private PushSync(BuilderImpl builder) {
        this.applicationArns = builder.applicationArns;
        this.roleArn = builder.roleArn;
    }

    /**
     * Returns true if the ApplicationArns property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasApplicationArns() {
        return applicationArns != null && !(applicationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of SNS platform application ARNs that could be used by clients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApplicationArns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of SNS platform application ARNs that could be used by clients.
     */
    public List<String> applicationArns() {
        return applicationArns;
    }

    /**
     * <p>
     * A role configured to allow Cognito to call SNS on behalf of the developer.
     * </p>
     * 
     * @return A role configured to allow Cognito to call SNS on behalf of the developer.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationArns());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushSync)) {
            return false;
        }
        PushSync other = (PushSync) obj;
        return Objects.equals(applicationArns(), other.applicationArns()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PushSync").add("ApplicationArns", applicationArns()).add("RoleArn", roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArns":
            return Optional.ofNullable(clazz.cast(applicationArns()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushSync, T> g) {
        return obj -> g.apply((PushSync) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushSync> {
        /**
         * <p>
         * List of SNS platform application ARNs that could be used by clients.
         * </p>
         * 
         * @param applicationArns
         *        List of SNS platform application ARNs that could be used by clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArns(Collection<String> applicationArns);

        /**
         * <p>
         * List of SNS platform application ARNs that could be used by clients.
         * </p>
         * 
         * @param applicationArns
         *        List of SNS platform application ARNs that could be used by clients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArns(String... applicationArns);

        /**
         * <p>
         * A role configured to allow Cognito to call SNS on behalf of the developer.
         * </p>
         * 
         * @param roleArn
         *        A role configured to allow Cognito to call SNS on behalf of the developer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> applicationArns = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PushSync model) {
            applicationArns(model.applicationArns);
            roleArn(model.roleArn);
        }

        public final Collection<String> getApplicationArns() {
            return applicationArns;
        }

        @Override
        public final Builder applicationArns(Collection<String> applicationArns) {
            this.applicationArns = ApplicationArnListCopier.copy(applicationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationArns(String... applicationArns) {
            applicationArns(Arrays.asList(applicationArns));
            return this;
        }

        public final void setApplicationArns(Collection<String> applicationArns) {
            this.applicationArns = ApplicationArnListCopier.copy(applicationArns);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public PushSync build() {
            return new PushSync(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
