/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.services.cognitosync.model.MergedDatasetNameListCopier;
import software.amazon.awssdk.services.cognitosync.model.Record;
import software.amazon.awssdk.services.cognitosync.model.RecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListRecordsResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, ListRecordsResponse> {
    private final List<Record> records;
    private final String nextToken;
    private final Integer count;
    private final Long datasetSyncCount;
    private final String lastModifiedBy;
    private final List<String> mergedDatasetNames;
    private final Boolean datasetExists;
    private final Boolean datasetDeletedAfterRequestedSyncCount;
    private final String syncSessionToken;

    private ListRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextToken = builder.nextToken;
        this.count = builder.count;
        this.datasetSyncCount = builder.datasetSyncCount;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.mergedDatasetNames = builder.mergedDatasetNames;
        this.datasetExists = builder.datasetExists;
        this.datasetDeletedAfterRequestedSyncCount = builder.datasetDeletedAfterRequestedSyncCount;
        this.syncSessionToken = builder.syncSessionToken;
    }

    public List<Record> records() {
        return this.records;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer count() {
        return this.count;
    }

    public Long datasetSyncCount() {
        return this.datasetSyncCount;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public List<String> mergedDatasetNames() {
        return this.mergedDatasetNames;
    }

    public Boolean datasetExists() {
        return this.datasetExists;
    }

    public Boolean datasetDeletedAfterRequestedSyncCount() {
        return this.datasetDeletedAfterRequestedSyncCount;
    }

    public String syncSessionToken() {
        return this.syncSessionToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetSyncCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergedDatasetNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetExists());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetDeletedAfterRequestedSyncCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSessionToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecordsResponse)) {
            return false;
        }
        ListRecordsResponse other = (ListRecordsResponse)((Object)obj);
        return Objects.equals(this.records(), other.records()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.datasetSyncCount(), other.datasetSyncCount()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.mergedDatasetNames(), other.mergedDatasetNames()) && Objects.equals(this.datasetExists(), other.datasetExists()) && Objects.equals(this.datasetDeletedAfterRequestedSyncCount(), other.datasetDeletedAfterRequestedSyncCount()) && Objects.equals(this.syncSessionToken(), other.syncSessionToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRecordsResponse").add("Records", this.records()).add("NextToken", (Object)this.nextToken()).add("Count", (Object)this.count()).add("DatasetSyncCount", (Object)this.datasetSyncCount()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("MergedDatasetNames", this.mergedDatasetNames()).add("DatasetExists", (Object)this.datasetExists()).add("DatasetDeletedAfterRequestedSyncCount", (Object)this.datasetDeletedAfterRequestedSyncCount()).add("SyncSessionToken", (Object)this.syncSessionToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.of(clazz.cast(this.records()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "Count": {
                return Optional.of(clazz.cast(this.count()));
            }
            case "DatasetSyncCount": {
                return Optional.of(clazz.cast(this.datasetSyncCount()));
            }
            case "LastModifiedBy": {
                return Optional.of(clazz.cast(this.lastModifiedBy()));
            }
            case "MergedDatasetNames": {
                return Optional.of(clazz.cast(this.mergedDatasetNames()));
            }
            case "DatasetExists": {
                return Optional.of(clazz.cast(this.datasetExists()));
            }
            case "DatasetDeletedAfterRequestedSyncCount": {
                return Optional.of(clazz.cast(this.datasetDeletedAfterRequestedSyncCount()));
            }
            case "SyncSessionToken": {
                return Optional.of(clazz.cast(this.syncSessionToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private List<Record> records;
        private String nextToken;
        private Integer count;
        private Long datasetSyncCount;
        private String lastModifiedBy;
        private List<String> mergedDatasetNames;
        private Boolean datasetExists;
        private Boolean datasetDeletedAfterRequestedSyncCount;
        private String syncSessionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecordsResponse model) {
            this.records(model.records);
            this.nextToken(model.nextToken);
            this.count(model.count);
            this.datasetSyncCount(model.datasetSyncCount);
            this.lastModifiedBy(model.lastModifiedBy);
            this.mergedDatasetNames(model.mergedDatasetNames);
            this.datasetExists(model.datasetExists);
            this.datasetDeletedAfterRequestedSyncCount(model.datasetDeletedAfterRequestedSyncCount);
            this.syncSessionToken(model.syncSessionToken);
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Long getDatasetSyncCount() {
            return this.datasetSyncCount;
        }

        @Override
        public final Builder datasetSyncCount(Long datasetSyncCount) {
            this.datasetSyncCount = datasetSyncCount;
            return this;
        }

        public final void setDatasetSyncCount(Long datasetSyncCount) {
            this.datasetSyncCount = datasetSyncCount;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final Collection<String> getMergedDatasetNames() {
            return this.mergedDatasetNames;
        }

        @Override
        public final Builder mergedDatasetNames(Collection<String> mergedDatasetNames) {
            this.mergedDatasetNames = MergedDatasetNameListCopier.copy(mergedDatasetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergedDatasetNames(String ... mergedDatasetNames) {
            this.mergedDatasetNames(Arrays.asList(mergedDatasetNames));
            return this;
        }

        public final void setMergedDatasetNames(Collection<String> mergedDatasetNames) {
            this.mergedDatasetNames = MergedDatasetNameListCopier.copy(mergedDatasetNames);
        }

        public final Boolean getDatasetExists() {
            return this.datasetExists;
        }

        @Override
        public final Builder datasetExists(Boolean datasetExists) {
            this.datasetExists = datasetExists;
            return this;
        }

        public final void setDatasetExists(Boolean datasetExists) {
            this.datasetExists = datasetExists;
        }

        public final Boolean getDatasetDeletedAfterRequestedSyncCount() {
            return this.datasetDeletedAfterRequestedSyncCount;
        }

        @Override
        public final Builder datasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
            this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
            return this;
        }

        public final void setDatasetDeletedAfterRequestedSyncCount(Boolean datasetDeletedAfterRequestedSyncCount) {
            this.datasetDeletedAfterRequestedSyncCount = datasetDeletedAfterRequestedSyncCount;
        }

        public final String getSyncSessionToken() {
            return this.syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        @Override
        public ListRecordsResponse build() {
            return new ListRecordsResponse(this);
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    CopyableBuilder<Builder, ListRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder nextToken(String var1);

        public Builder count(Integer var1);

        public Builder datasetSyncCount(Long var1);

        public Builder lastModifiedBy(String var1);

        public Builder mergedDatasetNames(Collection<String> var1);

        public Builder mergedDatasetNames(String ... var1);

        public Builder datasetExists(Boolean var1);

        public Builder datasetDeletedAfterRequestedSyncCount(Boolean var1);

        public Builder syncSessionToken(String var1);
    }
}

