/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitosync.model.Operation;
import software.amazon.awssdk.services.cognitosync.transform.RecordPatchMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordPatch
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordPatch> {
    private final String op;
    private final String key;
    private final String value;
    private final Long syncCount;
    private final Instant deviceLastModifiedDate;

    private RecordPatch(BuilderImpl builder) {
        this.op = builder.op;
        this.key = builder.key;
        this.value = builder.value;
        this.syncCount = builder.syncCount;
        this.deviceLastModifiedDate = builder.deviceLastModifiedDate;
    }

    public String op() {
        return this.op;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Long syncCount() {
        return this.syncCount;
    }

    public Instant deviceLastModifiedDate() {
        return this.deviceLastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.op() == null ? 0 : this.op().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.syncCount() == null ? 0 : this.syncCount().hashCode());
        hashCode = 31 * hashCode + (this.deviceLastModifiedDate() == null ? 0 : this.deviceLastModifiedDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordPatch)) {
            return false;
        }
        RecordPatch other = (RecordPatch)obj;
        if (other.op() == null ^ this.op() == null) {
            return false;
        }
        if (other.op() != null && !other.op().equals(this.op())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.syncCount() == null ^ this.syncCount() == null) {
            return false;
        }
        if (other.syncCount() != null && !other.syncCount().equals(this.syncCount())) {
            return false;
        }
        if (other.deviceLastModifiedDate() == null ^ this.deviceLastModifiedDate() == null) {
            return false;
        }
        return other.deviceLastModifiedDate() == null || other.deviceLastModifiedDate().equals(this.deviceLastModifiedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.op() != null) {
            sb.append("Op: ").append(this.op()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.syncCount() != null) {
            sb.append("SyncCount: ").append(this.syncCount()).append(",");
        }
        if (this.deviceLastModifiedDate() != null) {
            sb.append("DeviceLastModifiedDate: ").append(this.deviceLastModifiedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordPatchMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String op;
        private String key;
        private String value;
        private Long syncCount;
        private Instant deviceLastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordPatch model) {
            this.setOp(model.op);
            this.setKey(model.key);
            this.setValue(model.value);
            this.setSyncCount(model.syncCount);
            this.setDeviceLastModifiedDate(model.deviceLastModifiedDate);
        }

        public final String getOp() {
            return this.op;
        }

        @Override
        public final Builder op(String op) {
            this.op = op;
            return this;
        }

        @Override
        public final Builder op(Operation op) {
            this.op(op.toString());
            return this;
        }

        public final void setOp(String op) {
            this.op = op;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Long getSyncCount() {
            return this.syncCount;
        }

        @Override
        public final Builder syncCount(Long syncCount) {
            this.syncCount = syncCount;
            return this;
        }

        public final void setSyncCount(Long syncCount) {
            this.syncCount = syncCount;
        }

        public final Instant getDeviceLastModifiedDate() {
            return this.deviceLastModifiedDate;
        }

        @Override
        public final Builder deviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
            return this;
        }

        public final void setDeviceLastModifiedDate(Instant deviceLastModifiedDate) {
            this.deviceLastModifiedDate = deviceLastModifiedDate;
        }

        public RecordPatch build() {
            return new RecordPatch(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordPatch> {
        public Builder op(String var1);

        public Builder op(Operation var1);

        public Builder key(String var1);

        public Builder value(String var1);

        public Builder syncCount(Long var1);

        public Builder deviceLastModifiedDate(Instant var1);
    }
}

