/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cognitosync.model.Dataset;

public class DatasetUnmarshaller
implements Unmarshaller<Dataset, JsonUnmarshallerContext> {
    private static final DatasetUnmarshaller INSTANCE = new DatasetUnmarshaller();

    public Dataset unmarshall(JsonUnmarshallerContext context) throws Exception {
        Dataset.Builder datasetBuilder = Dataset.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("IdentityId", targetDepth)) {
                    context.nextToken();
                    datasetBuilder.identityId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DatasetName", targetDepth)) {
                    context.nextToken();
                    datasetBuilder.datasetName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    context.nextToken();
                    datasetBuilder.creationDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedDate", targetDepth)) {
                    context.nextToken();
                    datasetBuilder.lastModifiedDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModifiedBy", targetDepth)) {
                    context.nextToken();
                    datasetBuilder.lastModifiedBy((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataStorage", targetDepth)) {
                    context.nextToken();
                    datasetBuilder.dataStorage((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("NumRecords", targetDepth)) {
                    context.nextToken();
                    datasetBuilder.numRecords((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Dataset)datasetBuilder.build();
    }

    public static DatasetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

