/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cognitosync.CognitoSyncClient;
import software.amazon.awssdk.services.cognitosync.model.AlreadyStreamedException;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishRequest;
import software.amazon.awssdk.services.cognitosync.model.BulkPublishResponse;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncException;
import software.amazon.awssdk.services.cognitosync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.DescribeIdentityUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.DuplicateRequestException;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetBulkPublishDetailsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.GetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.GetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.InternalErrorException;
import software.amazon.awssdk.services.cognitosync.model.InvalidConfigurationException;
import software.amazon.awssdk.services.cognitosync.model.InvalidLambdaFunctionOutputException;
import software.amazon.awssdk.services.cognitosync.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitosync.model.LambdaThrottledException;
import software.amazon.awssdk.services.cognitosync.model.LimitExceededException;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListDatasetsResponse;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageRequest;
import software.amazon.awssdk.services.cognitosync.model.ListIdentityPoolUsageResponse;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.ListRecordsResponse;
import software.amazon.awssdk.services.cognitosync.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceRequest;
import software.amazon.awssdk.services.cognitosync.model.RegisterDeviceResponse;
import software.amazon.awssdk.services.cognitosync.model.ResourceConflictException;
import software.amazon.awssdk.services.cognitosync.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsRequest;
import software.amazon.awssdk.services.cognitosync.model.SetCognitoEventsResponse;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationRequest;
import software.amazon.awssdk.services.cognitosync.model.SetIdentityPoolConfigurationResponse;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.SubscribeToDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetRequest;
import software.amazon.awssdk.services.cognitosync.model.UnsubscribeFromDatasetResponse;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsRequest;
import software.amazon.awssdk.services.cognitosync.model.UpdateRecordsResponse;
import software.amazon.awssdk.services.cognitosync.transform.BulkPublishRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.BulkPublishResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DeleteDatasetResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeDatasetResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityPoolUsageResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.DescribeIdentityUsageResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetBulkPublishDetailsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetBulkPublishDetailsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetCognitoEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetCognitoEventsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetIdentityPoolConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.GetIdentityPoolConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListDatasetsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListIdentityPoolUsageRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListIdentityPoolUsageResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListRecordsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.ListRecordsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.RegisterDeviceRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.RegisterDeviceResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetCognitoEventsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetCognitoEventsResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetIdentityPoolConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SetIdentityPoolConfigurationResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SubscribeToDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.SubscribeToDatasetResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UnsubscribeFromDatasetRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UnsubscribeFromDatasetResponseUnmarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UpdateRecordsRequestMarshaller;
import software.amazon.awssdk.services.cognitosync.transform.UpdateRecordsResponseUnmarshaller;

@SdkInternalApi
final class DefaultCognitoSyncClient
implements CognitoSyncClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoSyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "cognito-sync";
    }

    @Override
    public BulkPublishResponse bulkPublish(BulkPublishRequest bulkPublishRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, DuplicateRequestException, AlreadyStreamedException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BulkPublishResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (BulkPublishResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)bulkPublishRequest).withMarshaller((Marshaller)new BulkPublishRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest deleteDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, ResourceConflictException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDatasetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDatasetRequest).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest describeDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDatasetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDatasetRequest).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeIdentityPoolUsageResponse describeIdentityPoolUsage(DescribeIdentityPoolUsageRequest describeIdentityPoolUsageRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeIdentityPoolUsageResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeIdentityPoolUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIdentityPoolUsageRequest).withMarshaller((Marshaller)new DescribeIdentityPoolUsageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeIdentityUsageResponse describeIdentityUsage(DescribeIdentityUsageRequest describeIdentityUsageRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeIdentityUsageResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeIdentityUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIdentityUsageRequest).withMarshaller((Marshaller)new DescribeIdentityUsageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetBulkPublishDetailsResponse getBulkPublishDetails(GetBulkPublishDetailsRequest getBulkPublishDetailsRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBulkPublishDetailsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetBulkPublishDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBulkPublishDetailsRequest).withMarshaller((Marshaller)new GetBulkPublishDetailsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCognitoEventsResponse getCognitoEvents(GetCognitoEventsRequest getCognitoEventsRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCognitoEventsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetCognitoEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCognitoEventsRequest).withMarshaller((Marshaller)new GetCognitoEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetIdentityPoolConfigurationResponse getIdentityPoolConfiguration(GetIdentityPoolConfigurationRequest getIdentityPoolConfigurationRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIdentityPoolConfigurationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetIdentityPoolConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityPoolConfigurationRequest).withMarshaller((Marshaller)new GetIdentityPoolConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDatasetsResponse listDatasets(ListDatasetsRequest listDatasetsRequest) throws NotAuthorizedException, InvalidParameterException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDatasetsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListDatasetsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDatasetsRequest).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListIdentityPoolUsageResponse listIdentityPoolUsage(ListIdentityPoolUsageRequest listIdentityPoolUsageRequest) throws NotAuthorizedException, InvalidParameterException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIdentityPoolUsageResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListIdentityPoolUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentityPoolUsageRequest).withMarshaller((Marshaller)new ListIdentityPoolUsageRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListRecordsResponse listRecords(ListRecordsRequest listRecordsRequest) throws InvalidParameterException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRecordsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRecordsRequest).withMarshaller((Marshaller)new ListRecordsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RegisterDeviceResponse registerDevice(RegisterDeviceRequest registerDeviceRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterDeviceResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (RegisterDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerDeviceRequest).withMarshaller((Marshaller)new RegisterDeviceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetCognitoEventsResponse setCognitoEvents(SetCognitoEventsRequest setCognitoEventsRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, InternalErrorException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetCognitoEventsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SetCognitoEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setCognitoEventsRequest).withMarshaller((Marshaller)new SetCognitoEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SetIdentityPoolConfigurationResponse setIdentityPoolConfiguration(SetIdentityPoolConfigurationRequest setIdentityPoolConfigurationRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, TooManyRequestsException, ConcurrentModificationException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetIdentityPoolConfigurationResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SetIdentityPoolConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityPoolConfigurationRequest).withMarshaller((Marshaller)new SetIdentityPoolConfigurationRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SubscribeToDatasetResponse subscribeToDataset(SubscribeToDatasetRequest subscribeToDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SubscribeToDatasetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SubscribeToDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)subscribeToDatasetRequest).withMarshaller((Marshaller)new SubscribeToDatasetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UnsubscribeFromDatasetResponse unsubscribeFromDataset(UnsubscribeFromDatasetRequest unsubscribeFromDatasetRequest) throws NotAuthorizedException, InvalidParameterException, ResourceNotFoundException, InternalErrorException, InvalidConfigurationException, TooManyRequestsException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UnsubscribeFromDatasetResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UnsubscribeFromDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unsubscribeFromDatasetRequest).withMarshaller((Marshaller)new UnsubscribeFromDatasetRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateRecordsResponse updateRecords(UpdateRecordsRequest updateRecordsRequest) throws InvalidParameterException, LimitExceededException, NotAuthorizedException, ResourceNotFoundException, ResourceConflictException, InvalidLambdaFunctionOutputException, LambdaThrottledException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoSyncException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRecordsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateRecordsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRecordsRequest).withMarshaller((Marshaller)new UpdateRecordsRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(CognitoSyncException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModification").withModeledClass(ConcurrentModificationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidConfiguration").withModeledClass(InvalidConfigurationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameter").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFound").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceConflict").withModeledClass(ResourceConflictException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LambdaThrottled").withModeledClass(LambdaThrottledException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotAuthorizedError").withModeledClass(NotAuthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalError").withModeledClass(InternalErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequests").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLambdaFunctionOutput").withModeledClass(InvalidLambdaFunctionOutputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceeded").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AlreadyStreamed").withModeledClass(AlreadyStreamedException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

