/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitosync.model.RecordPatch;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecordPatchMarshaller {
    private static final MarshallingInfo<String> OP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Op").isBinary(false).build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<Long> SYNCCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncCount").isBinary(false).build();
    private static final MarshallingInfo<Instant> DEVICELASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceLastModifiedDate").isBinary(false).build();
    private static final RecordPatchMarshaller INSTANCE = new RecordPatchMarshaller();

    private RecordPatchMarshaller() {
    }

    public static RecordPatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecordPatch recordPatch, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recordPatch, (String)"recordPatch");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)recordPatch.opAsString(), OP_BINDING);
            protocolMarshaller.marshall((Object)recordPatch.key(), KEY_BINDING);
            protocolMarshaller.marshall((Object)recordPatch.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)recordPatch.syncCount(), SYNCCOUNT_BINDING);
            protocolMarshaller.marshall((Object)recordPatch.deviceLastModifiedDate(), DEVICELASTMODIFIEDDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

