/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.cognitosync.model.CognitoSyncResponse;
import software.amazon.awssdk.services.cognitosync.model.Dataset;
import software.amazon.awssdk.services.cognitosync.model.DatasetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDatasetsResponse
extends CognitoSyncResponse
implements ToCopyableBuilder<Builder, ListDatasetsResponse> {
    private final List<Dataset> datasets;
    private final Integer count;
    private final String nextToken;

    private ListDatasetsResponse(BuilderImpl builder) {
        super(builder);
        this.datasets = builder.datasets;
        this.count = builder.count;
        this.nextToken = builder.nextToken;
    }

    public List<Dataset> datasets() {
        return this.datasets;
    }

    public Integer count() {
        return this.count;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasets());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetsResponse)) {
            return false;
        }
        ListDatasetsResponse other = (ListDatasetsResponse)((Object)obj);
        return Objects.equals(this.datasets(), other.datasets()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDatasetsResponse").add("Datasets", this.datasets()).add("Count", (Object)this.count()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Datasets": {
                return Optional.of(clazz.cast(this.datasets()));
            }
            case "Count": {
                return Optional.of(clazz.cast(this.count()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoSyncResponse.BuilderImpl
    implements Builder {
        private List<Dataset> datasets;
        private Integer count;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetsResponse model) {
            super(model);
            this.datasets(model.datasets);
            this.count(model.count);
            this.nextToken(model.nextToken);
        }

        public final Collection<Dataset.Builder> getDatasets() {
            return this.datasets != null ? (Collection)this.datasets.stream().map(Dataset::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datasets(Collection<Dataset> datasets) {
            this.datasets = DatasetListCopier.copy(datasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Dataset ... datasets) {
            this.datasets(Arrays.asList(datasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasets(Consumer<Dataset.Builder> ... datasets) {
            this.datasets(Stream.of(datasets).map(c -> (Dataset)((Dataset.Builder)Dataset.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatasets(Collection<Dataset.BuilderImpl> datasets) {
            this.datasets = DatasetListCopier.copyFromBuilder(datasets);
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatasetsResponse build() {
            return new ListDatasetsResponse(this);
        }
    }

    public static interface Builder
    extends CognitoSyncResponse.Builder,
    CopyableBuilder<Builder, ListDatasetsResponse> {
        public Builder datasets(Collection<Dataset> var1);

        public Builder datasets(Dataset ... var1);

        public Builder datasets(Consumer<Dataset.Builder> ... var1);

        public Builder count(Integer var1);

        public Builder nextToken(String var1);
    }
}

