/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserImportJobType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UserImportJobTypeMarshaller {
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobId").isBinary(false).build();
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> PRESIGNEDURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreSignedUrl").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> COMPLETIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDate").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> CLOUDWATCHLOGSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchLogsRoleArn").isBinary(false).build();
    private static final MarshallingInfo<Long> IMPORTEDUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportedUsers").isBinary(false).build();
    private static final MarshallingInfo<Long> SKIPPEDUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SkippedUsers").isBinary(false).build();
    private static final MarshallingInfo<Long> FAILEDUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailedUsers").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLETIONMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionMessage").isBinary(false).build();
    private static final UserImportJobTypeMarshaller INSTANCE = new UserImportJobTypeMarshaller();

    private UserImportJobTypeMarshaller() {
    }

    public static UserImportJobTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UserImportJobType userImportJobType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)userImportJobType, (String)"userImportJobType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)userImportJobType.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.preSignedUrl(), PRESIGNEDURL_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.startDate(), STARTDATE_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.completionDate(), COMPLETIONDATE_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.cloudWatchLogsRoleArn(), CLOUDWATCHLOGSROLEARN_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.importedUsers(), IMPORTEDUSERS_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.skippedUsers(), SKIPPEDUSERS_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.failedUsers(), FAILEDUSERS_BINDING);
            protocolMarshaller.marshall((Object)userImportJobType.completionMessage(), COMPLETIONMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

