/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateResourceServerRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.UpdateResourceServerRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateResourceServerRequestMarshaller
implements Marshaller<Request<UpdateResourceServerRequest>, UpdateResourceServerRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSCognitoIdentityProviderService.UpdateResourceServer").serviceName("Amazon Cognito Identity Provider").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public UpdateResourceServerRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateResourceServerRequest> marshall(UpdateResourceServerRequest updateResourceServerRequest) {
        Validate.paramNotNull((Object)((Object)updateResourceServerRequest), (String)"updateResourceServerRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)updateResourceServerRequest);
            protocolMarshaller.startMarshalling();
            UpdateResourceServerRequestModelMarshaller.getInstance().marshall(updateResourceServerRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

