/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateIdentityProviderRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderName").isBinary(false).build();
    private static final MarshallingInfo<Map> PROVIDERDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderDetails").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTEMAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeMapping").isBinary(false).build();
    private static final MarshallingInfo<List> IDPIDENTIFIERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdpIdentifiers").isBinary(false).build();
    private static final UpdateIdentityProviderRequestModelMarshaller INSTANCE = new UpdateIdentityProviderRequestModelMarshaller();

    private UpdateIdentityProviderRequestModelMarshaller() {
    }

    public static UpdateIdentityProviderRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateIdentityProviderRequest updateIdentityProviderRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateIdentityProviderRequest), (String)"updateIdentityProviderRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateIdentityProviderRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)updateIdentityProviderRequest.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall(updateIdentityProviderRequest.providerDetails(), PROVIDERDETAILS_BINDING);
            protocolMarshaller.marshall(updateIdentityProviderRequest.attributeMapping(), ATTRIBUTEMAPPING_BINDING);
            protocolMarshaller.marshall(updateIdentityProviderRequest.idpIdentifiers(), IDPIDENTIFIERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

