/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UICustomizationType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UICustomizationTypeMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientId").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImageUrl").isBinary(false).build();
    private static final MarshallingInfo<String> CSS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CSS").isBinary(false).build();
    private static final MarshallingInfo<String> CSSVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CSSVersion").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final UICustomizationTypeMarshaller INSTANCE = new UICustomizationTypeMarshaller();

    private UICustomizationTypeMarshaller() {
    }

    public static UICustomizationTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UICustomizationType uiCustomizationType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)uiCustomizationType, (String)"uiCustomizationType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)uiCustomizationType.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)uiCustomizationType.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)uiCustomizationType.imageUrl(), IMAGEURL_BINDING);
            protocolMarshaller.marshall((Object)uiCustomizationType.css(), CSS_BINDING);
            protocolMarshaller.marshall((Object)uiCustomizationType.cssVersion(), CSSVERSION_BINDING);
            protocolMarshaller.marshall((Object)uiCustomizationType.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)uiCustomizationType.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

