/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StringAttributeConstraintsType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StringAttributeConstraintsTypeMarshaller {
    private static final MarshallingInfo<String> MINLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinLength").isBinary(false).build();
    private static final MarshallingInfo<String> MAXLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxLength").isBinary(false).build();
    private static final StringAttributeConstraintsTypeMarshaller INSTANCE = new StringAttributeConstraintsTypeMarshaller();

    private StringAttributeConstraintsTypeMarshaller() {
    }

    public static StringAttributeConstraintsTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StringAttributeConstraintsType stringAttributeConstraintsType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stringAttributeConstraintsType, (String)"stringAttributeConstraintsType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stringAttributeConstraintsType.minLength(), MINLENGTH_BINDING);
            protocolMarshaller.marshall((Object)stringAttributeConstraintsType.maxLength(), MAXLENGTH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

