/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProviderDescriptionMarshaller {
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderName").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderType").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final ProviderDescriptionMarshaller INSTANCE = new ProviderDescriptionMarshaller();

    private ProviderDescriptionMarshaller() {
    }

    public static ProviderDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProviderDescription providerDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)providerDescription, (String)"providerDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)providerDescription.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall((Object)providerDescription.providerTypeAsString(), PROVIDERTYPE_BINDING);
            protocolMarshaller.marshall((Object)providerDescription.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)providerDescription.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

