/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MessageTemplateType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MessageTemplateTypeMarshaller {
    private static final MarshallingInfo<String> SMSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SMSMessage").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailMessage").isBinary(false).build();
    private static final MarshallingInfo<String> EMAILSUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailSubject").isBinary(false).build();
    private static final MessageTemplateTypeMarshaller INSTANCE = new MessageTemplateTypeMarshaller();

    private MessageTemplateTypeMarshaller() {
    }

    public static MessageTemplateTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MessageTemplateType messageTemplateType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)messageTemplateType, (String)"messageTemplateType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)messageTemplateType.smsMessage(), SMSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageTemplateType.emailMessage(), EMAILMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageTemplateType.emailSubject(), EMAILSUBJECT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

