/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.GlobalSignOutRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GlobalSignOutRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCESSTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessToken").isBinary(false).build();
    private static final GlobalSignOutRequestModelMarshaller INSTANCE = new GlobalSignOutRequestModelMarshaller();

    private GlobalSignOutRequestModelMarshaller() {
    }

    public static GlobalSignOutRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlobalSignOutRequest globalSignOutRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)globalSignOutRequest), (String)"globalSignOutRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)globalSignOutRequest.accessToken(), ACCESSTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

