/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DescribeUserImportJobRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.transform.DescribeUserImportJobRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeUserImportJobRequestMarshaller
implements Marshaller<Request<DescribeUserImportJobRequest>, DescribeUserImportJobRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWSCognitoIdentityProviderService.DescribeUserImportJob").serviceName("Amazon Cognito Identity Provider").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DescribeUserImportJobRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeUserImportJobRequest> marshall(DescribeUserImportJobRequest describeUserImportJobRequest) {
        Validate.paramNotNull((Object)((Object)describeUserImportJobRequest), (String)"describeUserImportJobRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeUserImportJobRequest);
            protocolMarshaller.startMarshalling();
            DescribeUserImportJobRequestModelMarshaller.getInstance().marshall(describeUserImportJobRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

