/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateUserPoolClientRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateUserPoolClientRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientName").isBinary(false).build();
    private static final MarshallingInfo<Boolean> GENERATESECRET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GenerateSecret").isBinary(false).build();
    private static final MarshallingInfo<Integer> REFRESHTOKENVALIDITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RefreshTokenValidity").isBinary(false).build();
    private static final MarshallingInfo<List> READATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> WRITEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WriteAttributes").isBinary(false).build();
    private static final MarshallingInfo<List> EXPLICITAUTHFLOWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExplicitAuthFlows").isBinary(false).build();
    private static final MarshallingInfo<List> SUPPORTEDIDENTITYPROVIDERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedIdentityProviders").isBinary(false).build();
    private static final MarshallingInfo<List> CALLBACKURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CallbackURLs").isBinary(false).build();
    private static final MarshallingInfo<List> LOGOUTURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogoutURLs").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTREDIRECTURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultRedirectURI").isBinary(false).build();
    private static final MarshallingInfo<List> ALLOWEDOAUTHFLOWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthFlows").isBinary(false).build();
    private static final MarshallingInfo<List> ALLOWEDOAUTHSCOPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthScopes").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ALLOWEDOAUTHFLOWSUSERPOOLCLIENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOAuthFlowsUserPoolClient").isBinary(false).build();
    private static final CreateUserPoolClientRequestModelMarshaller INSTANCE = new CreateUserPoolClientRequestModelMarshaller();

    private CreateUserPoolClientRequestModelMarshaller() {
    }

    public static CreateUserPoolClientRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateUserPoolClientRequest createUserPoolClientRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createUserPoolClientRequest), (String)"createUserPoolClientRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createUserPoolClientRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolClientRequest.clientName(), CLIENTNAME_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolClientRequest.generateSecret(), GENERATESECRET_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolClientRequest.refreshTokenValidity(), REFRESHTOKENVALIDITY_BINDING);
            protocolMarshaller.marshall(createUserPoolClientRequest.readAttributes(), READATTRIBUTES_BINDING);
            protocolMarshaller.marshall(createUserPoolClientRequest.writeAttributes(), WRITEATTRIBUTES_BINDING);
            protocolMarshaller.marshall(createUserPoolClientRequest.explicitAuthFlowsAsStrings(), EXPLICITAUTHFLOWS_BINDING);
            protocolMarshaller.marshall(createUserPoolClientRequest.supportedIdentityProviders(), SUPPORTEDIDENTITYPROVIDERS_BINDING);
            protocolMarshaller.marshall(createUserPoolClientRequest.callbackURLs(), CALLBACKURLS_BINDING);
            protocolMarshaller.marshall(createUserPoolClientRequest.logoutURLs(), LOGOUTURLS_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolClientRequest.defaultRedirectURI(), DEFAULTREDIRECTURI_BINDING);
            protocolMarshaller.marshall(createUserPoolClientRequest.allowedOAuthFlowsAsStrings(), ALLOWEDOAUTHFLOWS_BINDING);
            protocolMarshaller.marshall(createUserPoolClientRequest.allowedOAuthScopes(), ALLOWEDOAUTHSCOPES_BINDING);
            protocolMarshaller.marshall((Object)createUserPoolClientRequest.allowedOAuthFlowsUserPoolClient(), ALLOWEDOAUTHFLOWSUSERPOOLCLIENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

