/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateIdentityProviderRequestModelMarshaller {
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderName").isBinary(false).build();
    private static final MarshallingInfo<String> PROVIDERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderType").isBinary(false).build();
    private static final MarshallingInfo<Map> PROVIDERDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProviderDetails").isBinary(false).build();
    private static final MarshallingInfo<Map> ATTRIBUTEMAPPING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeMapping").isBinary(false).build();
    private static final MarshallingInfo<List> IDPIDENTIFIERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdpIdentifiers").isBinary(false).build();
    private static final CreateIdentityProviderRequestModelMarshaller INSTANCE = new CreateIdentityProviderRequestModelMarshaller();

    private CreateIdentityProviderRequestModelMarshaller() {
    }

    public static CreateIdentityProviderRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateIdentityProviderRequest createIdentityProviderRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createIdentityProviderRequest), (String)"createIdentityProviderRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createIdentityProviderRequest.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)createIdentityProviderRequest.providerName(), PROVIDERNAME_BINDING);
            protocolMarshaller.marshall((Object)createIdentityProviderRequest.providerTypeAsString(), PROVIDERTYPE_BINDING);
            protocolMarshaller.marshall(createIdentityProviderRequest.providerDetails(), PROVIDERDETAILS_BINDING);
            protocolMarshaller.marshall(createIdentityProviderRequest.attributeMapping(), ATTRIBUTEMAPPING_BINDING);
            protocolMarshaller.marshall(createIdentityProviderRequest.idpIdentifiers(), IDPIDENTIFIERS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

